% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MeasureClassifConfusion.R
\name{confusion_measures}
\alias{confusion_measures}
\title{Calculate Confusion Measures}
\usage{
confusion_measures(m, type = NULL)
}
\arguments{
\item{m}{:: \code{matrix()}\cr
Confusion matrix, e.g. as returned by field \code{confusion} of \link{PredictionClassif}.
Truth is in columns, predicted response is in rows.}

\item{type}{:: \code{character()}\cr
Selects the measure to use. See description for possible values.}
}
\value{
(named \code{numeric()}) of confusion measures.
}
\description{
Based on a 2x2 confusion matrix for binary classification problems, allows to calculate various performance measures.
Implemented are the following measures based on \url{https://en.wikipedia.org/wiki/Template:DiagnosticTesting_Diagram}:
\itemize{
\item \code{"tp"}: True Positives.
\item \code{"fn"}: False Negatives.
\item \code{"fp"}: False Positives.
\item \code{"tn"}: True Negatives.
\item \code{"tpr"}: True Positive Rate.
\item \code{"fnr"}: False Negative Rate.
\item \code{"fpr"}: False Positive Rate.
\item \code{"tnr"}: True Negative Rate.
\item \code{"ppv"}: Positive Predictive Value.
\item \code{"fdr"}: False Discovery Rate.
\item \code{"for"}: False Omission Rate.
\item \code{"npv"}: Negative Predictive Value.
\item \code{"precision"}: Alias for \code{"ppv"}.
\item \code{"recall"}: Alias for \code{"tpr"}.
\item \code{"sensitivity"}: Alias for \code{"tpr"}.
\item \code{"specificity"}: Alias for \code{"tnr"}.
}

If the denominator is 0, the returned score is \code{NA}.
}
\examples{
task = tsk("german_credit")
learner = lrn("classif.rpart")
p = learner$train(task)$predict(task)
round(confusion_measures(p$confusion), 2)
}
