% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generatePartialDependence.R
\name{generateFunctionalANOVAData}
\alias{FunctionalANOVAData}
\alias{generateFunctionalANOVAData}
\title{Generate a functional ANOVA decomposition}
\usage{
generateFunctionalANOVAData(obj, input, features, depth = 1L, fun = mean,
  bounds = c(qnorm(0.025), qnorm(0.975)), resample = "none", fmin, fmax,
  gridsize = 10L)
}
\arguments{
\item{obj}{[\code{\link{WrappedModel}}]\cr
Result of \code{\link{train}}.}

\item{input}{[\code{data.frame} | \code{\link{Task}}]\cr
Input data.}

\item{features}{[\code{character}]\cr
A vector of feature names contained in the training data.
If not specified all features in the \code{input} will be used.}

\item{depth}{[\code{integer(1)}]\cr
An integer indicating the depth of interaction amongst the features to compute. Default 1.}

\item{fun}{[\code{function}]\cr
A function that accepts a numeric vector and returns either a single number
such as a measure of location such as the mean, or three numbers, which give a lower bound,
a measure of location, and an upper bound. Note if three numbers are returned they must be
in this order. The default is the mean.}

\item{bounds}{[\code{numeric(2)}]\cr
The value (lower, upper) the estimated standard error is multiplied by to estimate the bound on a
confidence region for a partial dependence. Ignored if \code{predict.type != "se"} for the learner.
Default is the 2.5 and 97.5 quantiles (-1.96, 1.96) of the Gaussian distribution.}

\item{resample}{[\code{character(1)}]\cr
Defines how the prediction grid for each feature is created. If \dQuote{bootstrap} then
values are sampled with replacement from the training data. If \dQuote{subsample} then
values are sampled without replacement from the training data. If \dQuote{none} an evenly spaced
grid between either the empirical minimum and maximum, or the minimum and maximum defined by
\code{fmin} and \code{fmax}, is created.
Default is \dQuote{none}.}

\item{fmin}{[\code{numeric}]\cr
The minimum value that each element of \code{features} can take.
This argument is only applicable if \code{resample = NULL} and when the empirical minimum is higher
than the theoretical minimum for a given feature. This only applies to numeric features and a
\code{NA} should be inserted into the vector if the corresponding feature is a factor.
Default is the empirical minimum of each numeric feature and NA for factor features.}

\item{fmax}{[\code{numeric}]\cr
The maximum value that each element of \code{features} can take.
This argument is only applicable if \code{resample = "none"} and when the empirical maximum is lower
than the theoretical maximum for a given feature. This only applies to numeric features and a
\code{NA} should be inserted into the vector if the corresponding feature is a factor.
Default is the empirical maximum of each numeric feature and NA for factor features.}

\item{gridsize}{[\code{integer(1)}]\cr
The length of the prediction grid created for each feature.
If \code{resample = "bootstrap"} or \code{resample = "subsample"} then this defines
the number of (possibly non-unique) values resampled. If \code{resample = NULL} it defines the
length of the evenly spaced grid created. Default 10.}

\item{...}{additional arguments to be passed to \code{\link{predict}}.}
}
\value{
[\code{FunctionalANOVAData}]. A named list, which contains the computed effects of the specified
  depth amongst the features.

Object members:
  \item{data}{[\code{data.frame}]\cr
    Has columns for the prediction: one column for regression and an additional two if bounds are used.
    The \dQuote{effect} column specifies which features the prediction corresponds to.}
  \item{task.desc}{[\code{\link{TaskDesc}}]\cr
    Task description.}
  \item{target}{The target feature for regression.}
  \item{features}{[\code{character}]\cr
    Features argument input.}
  \item{interaction}{[\code{logical(1)}]\cr
    Whether or not the \code{depth} is greater than 1.}
}
\description{
Decompose a learned prediction function as a sum of components estimated via partial dependence.
}
\examples{
fit = train("regr.rpart", bh.task)
fa = generateFunctionalANOVAData(fit, bh.task, c("lstat", "crim"), depth = 2L)
plotPartialDependence(fa)
}
\references{
Giles Hooker, \dQuote{Discovering additive structure in black box functions.} Proceedings of the 10th ACM SIGKDD international conference on Knowledge discovery and data mining (2004): 575-580.
}
\seealso{
Other generate_plot_data: \code{\link{generateCalibrationData}},
  \code{\link{generateCritDifferencesData}},
  \code{\link{generateFilterValuesData}},
  \code{\link{generateLearningCurveData}},
  \code{\link{generatePartialDependenceData}},
  \code{\link{generateThreshVsPerfData}},
  \code{\link{getFilterValues}}
}

