% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/train.R
\name{train}
\alias{train}
\title{Train a learning algorithm.}
\usage{
train(learner, task, subset, weights = NULL)
}
\arguments{
\item{learner}{[\code{\link{Learner}} | \code{character(1)}]\cr
The learner.
If you pass a string the learner will be created via \code{\link{makeLearner}}.}

\item{task}{[\code{\link{Task}}]\cr
The task.}

\item{subset}{[\code{integer}]\cr
An index vector specifying the training cases to be used for fitting.
By default the complete data set is used.}

\item{weights}{[\code{numeric}]\cr
Optional, non-negative case weight vector to be used during fitting.
If given, must be of same length as \code{subset} and in corresponding order.
By default \code{NULL} which means no weights are used unless specified in the task ([\code{\link{Task}}]).
Weights from the task will be overwritten.}
}
\value{
[\code{\link{WrappedModel}}].
}
\description{
Given a \code{\link{Task}}, creates a model for the learning machine
which can be used for predictions on new data.
}
\examples{
training.set = sample(1:nrow(iris), nrow(iris) / 2)

## use linear discriminant analysis to classify iris data
task = makeClassifTask(data = iris, target = "Species")
learner = makeLearner("classif.lda", method = "mle")
mod = train(learner, task, subset = training.set)
print(mod)

## use random forest to classify iris data
task = makeClassifTask(data = iris, target = "Species")
learner = makeLearner("classif.rpart", minsplit = 7, predict.type = "prob")
mod = train(learner, task, subset = training.set)
print(mod)
}
\seealso{
\code{\link{predict.WrappedModel}}
}

