% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.designresult.R
\name{plot.designresult}
\alias{plot.designresult}
\title{Plot search result}
\usage{
\method{plot}{designresult}(
  x,
  design = NULL,
  adderrorbars = NULL,
  addribbon = NULL,
  trim = TRUE,
  type = "heat",
  color.width = 0.15,
  color.gradient = "diverging",
  ...
)
}
\arguments{
\item{x}{Object of class designresult as created by the find.design function.}

\item{design}{Specify a design as a list. Can be used to make a 1D plot for a two-dimensional simfun. Set NA for the dimension that should be plotted and set a value for all others. For example: design=list(n=NA,k=9)}

\item{adderrorbars}{logical. Plots errorbars in the 1D plot if TRUE. Default is FALSE (also if specified as NULL).}

\item{addribbon}{logical. Adds ribbon in the 1D plot if TRUE. Default is TRUE (also if specified as NULL).}

\item{trim}{logical. Option to trim the plotting area for the 2D line plot. The trimmed area is the area where the line is plotted. Default is TRUE.}

\item{type}{character indicating the type of the 2D plot. Can be 'heat'(default) or 'line'.}

\item{color.width}{numeric. Option for the diverging colormap in the 2D plot. Width of the blue-white colorband.}

\item{color.gradient}{character indicating whether the 2D plot should have a "diverging" color gradient (white-blue-white, default) or a "linear" color gradient (blue-red)}

\item{...}{additional arguments to be passed.}
}
\value{
A ggplot object
}
\description{
Plot a one- or two-dimensional graph of the result.
}
\examples{
#Load a simulation function
simfun = example.simfun('ttest')
# Perform the search
ds = find.design(simfun = simfun, boundaries = c(100,300), power = .95)
# Plot results
plot(ds)
}
