/**
 * @file src/random_forest.cpp
 *
 * This is an autogenerated file containing implementations of C++ functions to
 * be called by the R random_forest binding.
 */
#include <rcpp_mlpack.h>
#define BINDING_TYPE BINDING_TYPE_R
#include <mlpack/methods/random_forest/random_forest_main.cpp>

// [[Rcpp::export]]
void random_forest_mlpackMain()
{
  mlpackMain();
}

// Any implementations of methods for dealing with model pointers will be put
// below this comment, if needed.

// Get the pointer to a RandomForestModel parameter.
// [[Rcpp::export]]
SEXP IO_GetParamRandomForestModelPtr(const std::string& paramName)
{
  return std::move((Rcpp::XPtr<RandomForestModel>) IO::GetParam<RandomForestModel*>(paramName));
}

// Set the pointer to a RandomForestModel parameter.
// [[Rcpp::export]]
void IO_SetParamRandomForestModelPtr(const std::string& paramName, SEXP ptr)
{
  IO::GetParam<RandomForestModel*>(paramName) =  Rcpp::as<Rcpp::XPtr<RandomForestModel>>(ptr);
  IO::SetPassed(paramName);
}

// Serialize a RandomForestModel pointer.
// [[Rcpp::export]]
Rcpp::RawVector SerializeRandomForestModelPtr(SEXP ptr)
{
  std::ostringstream oss;
  {
    boost::archive::binary_oarchive oa(oss);
    oa << boost::serialization::make_nvp("RandomForestModel",
          *Rcpp::as<Rcpp::XPtr<RandomForestModel>>(ptr));
  }

  Rcpp::RawVector raw_vec(oss.str().size());

  // Copy the string buffer so we can return one that won't get deallocated when
  // we exit this function.
  memcpy(&raw_vec[0], oss.str().c_str(), oss.str().size());
  raw_vec.attr("type") = "RandomForestModel";
  return raw_vec;
}

// Deserialize a RandomForestModel pointer.
// [[Rcpp::export]]
SEXP DeserializeRandomForestModelPtr(Rcpp::RawVector str)
{
  RandomForestModel* ptr = new RandomForestModel();

  std::istringstream iss(std::string((char *) &str[0], str.size()));
  {
    boost::archive::binary_iarchive ia(iss);
    ia >> boost::serialization::make_nvp("RandomForestModel", *ptr);
  }

  // R will be responsible for freeing this.
  return std::move((Rcpp::XPtr<RandomForestModel>)ptr);
}


