% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dis_qcd.R
\encoding{UTF-8}
\name{dis_qcd}
\alias{dis_qcd}
\title{Constructs a pairwise distance matrix based on the quantile cross-spectral
density (QCD)}
\usage{
dis_qcd(X, levels = c(0.1, 0.5, 0.9), freq = NULL, features = FALSE, ...)
}
\arguments{
\item{X}{A list of MTS (numerical matrices).}

\item{levels}{The set of probability levels.}

\item{freq}{Vector of frequencies in which the smoothed CCR-periodograms
must be computed. If \code{freq=NULL} (default), the set of Fourier
frequencies is considered.}

\item{features}{Logical. If \code{features = FALSE} (default), a distance matrix is returned. Otherwise, the function
returns a dataset of feature vectors.}

\item{...}{Additional parameters for the function. See  \code{\link[quantspec]{smoothedPG}}.}
}
\value{
If \code{features = FALSE} (default), returns a distance matrix based on the distance \eqn{d_{QCD}}. Otherwise, the function
returns a dataset of feature vectors, i.e., each row in the dataset contains the features employed to compute the
distance \eqn{d_{QCF}}.
}
\description{
\code{dis_qcd} returns a pairwise distance matrix based on the
dissimilarity introduced by \insertCite{lopez2021quantile;textual}{mlmts}.
}
\details{
Given a collection of MTS, the function returns the pairwise distance matrix,
where the distance between two MTS \eqn{\boldsymbol X_T} and \eqn{\boldsymbol Y_T} is defined as
\deqn{d_{QCF}(\boldsymbol X_T, \boldsymbol Y_T)=\Bigg[\sum_{j_1=1}^{d}\sum_{j_2=1}^{d}\sum_{i=1}^{r}
\sum_{i'=1}^{r}\sum_{k=1}^{K}\Big(\Re\big({\widehat G_{j_1,j_2}^{\boldsymbol X_T}(\omega_{k}, \tau_{i}, \tau_{i^ {\prime}})}\big)
-\Re\big({\widehat G_{j_1,j_2}^{\boldsymbol Y_T}(\omega_{k}, \tau_{i}, \tau_{i^ {\prime}})\big)}\Big)^2+}
\deqn{\sum_{j_1=1}^{d}\sum_{j_2=1}^{d}\sum_{i=1}^{r}\sum_{i'=1}^{r}\sum_{k=1}^{K}\Big(\Im\big({\widehat G_{j_1,j_2}
^{\boldsymbol X_T}(\omega_{k}, \tau_{i}, \tau_{i^ {\prime}})}\big)
-\Im\big({\widehat G_{j_1,j_2}^{\boldsymbol Y_T}(\omega_{k}, \tau_{i}, \tau_{i^ {\prime}})\big)}\Big)^2\Bigg]^{1/2},}
where \eqn{{\widehat G_{j_1,j_2}^{\boldsymbol X_T}(\omega_{k}, \tau_{i}, \tau_{i^ {\prime}})}} and
\eqn{{\widehat G_{j_1,j_2}^{\boldsymbol Y_T}(\omega_{k}, \tau_{i}, \tau_{i^ {\prime}})}}
are estimates of the quantile cross-spectral densities (so-called smoothed CCR-periodograms)
with respect to the variables \eqn{j_1} and \eqn{j_2} and probability levels \eqn{\tau_i} and \eqn{\tau_{i^\prime}} for
series \eqn{\boldsymbol X_T} and \eqn{\boldsymbol Y_T}, respectively, and \eqn{\Re(\cdot)} and \eqn{\Im(\cdot)}
denote the real part and imaginary part operators, respectively.
}
\examples{
toy_dataset <- AtrialFibrillation$data[1 : 4] # Selecting the first 4 MTS from the
# dataset AtrialFibrillation
distance_matrix <- dis_qcd(toy_dataset) # Computing the pairwise
# distance matrix based on the distance dis_qcd
distance_matrix <- dis_qcd(toy_dataset, levels = c(0.4, 0.8)) # Changing
# the probability levels to compute the QCD-based estimators
distance_matrix <- dis_qcd(toy_dataset, freq = 0.5) # Considering only
# a single frequency for the computation of d_qcd
feature_dataset <- dis_qcd(toy_dataset, features = TRUE) # Computing
# the corresponding dataset of features
}
\references{
{

  \insertRef{lopez2021quantile}{mlmts}

}
}
\seealso{
\code{\link{dis_qcf}}
}
\author{
Ángel López-Oriona, José A. Vilar
}
