% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc2pca_clustering.R
\encoding{UTF-8}
\name{mc2pca_clustering}
\alias{mc2pca_clustering}
\title{Performs the crisp clustering algorithm of Li (2019)}
\usage{
mc2pca_clustering(X, k, var_rate = 0.9, max_it = 1000, tol = 1e-05)
}
\arguments{
\item{X}{A list of MTS (numerical matrices).}

\item{k}{The number of clusters.}

\item{var_rate}{Rate of retained variability concerning the
reconstructed MTS samples (default is 0.90).}

\item{max_it}{The maximum number of iterations (default is 1000).}

\item{tol}{The tolerance (default is 1e-5).}
}
\value{
A list with two elements:
\itemize{
\item \code{cluster}. A vector defining the clustering solution.
\item \code{iterations}. The number of iterations before the algorithm
stopped.
}
}
\description{
\code{mc2pca_clustering} performs the clustering algorithm proposed by
\insertCite{li2019multivariate;textual}{mlmts}, which is based on common principal component analysis (CPCA).
}
\details{
This function executes the crisp clustering method proposed by
. The algorithm is a \eqn{K}-means-type procedure where the distance
between a given MTS and a centroid is given by the reconstruction error
taking place when the series is reconstructed from the common space obtained
by considering all the series in the cluster associated with the corresponding
centroid (the common space is the centroid).
}
\examples{
clustering_algorithm <- mc2pca_clustering(BasicMotions$data, k = 4, var_rate = 0.30)
# Executing the clustering algorithm in the dataset BasicMotions (var_rate = 0.30,
# i.e., we keep only a few principal components for computing the reconstructed series)
clustering_algorithm$cluster # The clustering solution
clustering_algorithm$iterations # The number of iterations before the algorithm
library(ClusterR)
external_validation(clustering_algorithm$cluster, BasicMotions$classes,
summary_stats = TRUE) # Evaluating the clustering algorithms vs the true partition
# stopped
}
\references{
{

  \insertRef{li2019multivariate}{mlmts}

}
}
\author{
Ángel López-Oriona, José A. Vilar
}
