% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dis_zagorecki.R
\encoding{UTF-8}
\name{dis_zagorecki}
\alias{dis_zagorecki}
\title{Constructs a pairwise distance matrix based on feature extraction}
\usage{
dis_zagorecki(set, features = FALSE)
}
\arguments{
\item{set}{A list of MTS (numerical matrices).}

\item{features}{Logical. If \code{features = FALSE} (default), a distance matrix is returned. Otherwise, the function
returns a dataset of feature vectors.}
}
\value{
If \code{features = FALSE} (default), returns a distance matrix based on the distance \eqn{d_{ZAGORECKI}}. Otherwise, the function
returns a dataset of feature vectors, i.e., each row in the dataset contains the features employed to compute the
distance \eqn{d_{ZAGORECKI}}.
}
\description{
\code{dis_zagorecki} returns a pairwise distance matrix based on the feature
extraction procedure proposed by \insertCite{zagorecki2015versatile;textual}{mlmts}.
}
\details{
Given a collection of MTS, the function returns the pairwise distance matrix,
where the distance between two MTS is defined as the Euclidean distance
between the corresponding feature vectors
}
\examples{
toy_dataset <- AtrialFibrillation$data[1 : 10] # Selecting the first 10 MTS from the
# dataset AtrialFibrillation
distance_matrix <- dis_zagorecki(toy_dataset) # Computing the pairwise
# distance matrix based on the distance dis_zagorecki
feature_dataset <- dis_zagorecki(toy_dataset, features = TRUE) # Computing
# the corresponding dataset of features
}
\references{
{

  \insertRef{zagorecki2015versatile}{mlmts}

}
}
\author{
Ángel López-Oriona, José A. Vilar
}
