% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visits.R
\docType{data}
\name{visits}
\alias{visits}
\title{Field Visits}
\format{
A data frame with the following variables:
\describe{
\item{\code{site_nm}}{Local site name for a MLMS well.}
\item{\code{stime_dt}}{Start time for the field visit.}
\item{\code{etime_dt}}{End time for the field visit.}
\item{\code{baro_id}}{Identifier for the barometer used to measure atmospheric pressure.}
\item{\code{baro_start_va}}{Atmospheric pressure measured at the beginning of the field visit,
in pounds per square inch (psi).}
\item{\code{baro_end_va}}{Atmospheric pressure measured at the visits end, in psi.}
\item{\code{sensor_id}}{Identifier for the pressure sensor.}
\item{\code{press_start_va}}{Absolute pressure of fluid measured at the beginning of the field visit, in psi.}
\item{\code{press_end_va}}{Absolute pressure of fluid measured at the visits end, in psi.}
\item{\code{temp_start_va}}{Temperature of fluid measured at the beginning of the field visit,
in degree Celsius.}
\item{\code{temp_end_va}}{Temperature of fluid measured at the visits end,
in degree Celsius.}
\item{\code{operators}}{Initials of field operators.}
\item{\code{sheet_version_tx}}{Version of field sheet.}
\item{\code{weather}}{Weather conditions during the field visit.}
\item{\code{comment_tx}}{Comments.}
}
}
\source{
The dataset originates from the USGS INL Project Office
and underwent processing using the \code{\link{read_field_json}} function.
}
\usage{
visits
}
\description{
This dataset provides detailed information about the context and specifics of field visits.
It documents field visits to Multilevel Monitoring System (MLMS) wells in the U.S. Geological Survey (USGS)
aquifer-monitoring network, Idaho National Laboratory (INL), Idaho.
These visits involve measuring fluid pressure at various depths within an MLMS well,
typically completed within a few hours.
}
\examples{
str(visits)
}
\keyword{datasets}
