% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_samples.R
\name{get_samples}
\alias{get_samples}
\title{Retrieve Discrete Sample Data}
\usage{
get_samples(
  site_no = NULL,
  pcode = NULL,
  ports = mlms::ports,
  visits = mlms::visits
)
}
\arguments{
\item{site_no}{'character' vector.
USGS site identification number.
The site numbers of measurement ports in the Multilevel Monitoring System (MLMS) wells by default.}

\item{pcode}{'character' vector.
USGS 5-digit parameter code.
For a list of the parameter codes used by default, refer to the Details section.}

\item{ports}{'data.frame' table.
MLMS measurement port data, see \code{\link{ports}} dataset for data structure.}

\item{visits}{'data.frame' table.
Field visits, see \code{\link{visits}} dataset for data structure.}
}
\value{
A data frame, see \code{\link{samples}} dataset for table structure.
}
\description{
Retrieve discrete sample water-quality data from the \pkg{inldata} package.
See \code{\link[inldata:samples]{inldata::samples}} for a description of the source dataset.
Requires that the \pkg{indata} package is available.
}
\details{
The default parameters included are:
\describe{
\item{\code{00930}}{Sodium, water, filtered, in milligrams per liter (mg/L).}
\item{\code{00940}}{Chloride, water, filtered, in mg/L.}
\item{\code{00945}}{Sulfate, water, filtered, in mg/L.}
\item{\code{00950}}{Fluoride, water, filtered, in mg/L.}
\item{\code{01030}}{Chromium, water, filtered, in micrograms per liter.}
\item{\code{00618}}{Nitrate, water, filtered, in mg/L as nitrogen.}
\item{\code{07000}}{Tritium, water, unfiltered, in picocuries per liter (pCi/L).}
\item{\code{13501}}{Strontium-90, water, unfiltered, in pCi/L.}
\item{\code{22012}}{Plutonium-238, water, unfiltered, in pCi/L.}
\item{\code{28401}}{Cesium-137, water, unfiltered, in pCi/L.}
\item{\code{63018}}{Gross alpha radioactivity, water, unfiltered, Th-230 curve, in pCi/L.}
\item{\code{80049}}{Gross beta radioactivity, water, unfiltered, Sr-90/Y-90 curve, in pCi/L.}
\item{\code{00095}}{Specific conductance, water, unfiltered, in microsiemens per centimeter at 25 degrees Celsius.}
}
}
\examples{
\donttest{
  d <- get_samples(site_no = "433409112570503", pcode = "07000")
}
}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
