% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibrations.R
\docType{data}
\name{calibrations}
\alias{calibrations}
\title{Sensor Calibrations}
\format{
A data frame with the following variables:
\describe{
\item{\code{sensor_id}}{Identifier for the integrated sensor,
see \code{\link{sensors}} dataset for a description of each sensor.}
\item{\code{cal_dt}}{Calendar date of sensor calibration.}
\item{\code{cal_tp}}{Calibration type.}
\item{\code{ref_temp_va}}{Reference temperature, in degree Celsius.}
\item{\code{ts_dt}}{Date.}
\item{\code{lab_standard}}{Laboratory standard.}
\item{\code{r2}}{R-squared, coefficient of determination.}
\item{\code{p_value}}{p-value.}
}
}
\source{
The dataset originates from the USGS INL Project Office
and underwent processing using the \code{\link{read_sensors_json}} function.
}
\usage{
calibrations
}
\description{
Dataset of electronic sensor calibration measurements
in the Multilevel Monitoring System (MLMS) wells of the
U.S. Geological Survey (USGS) aquifer-monitoring network,
Idaho National Laboratory (INL), Idaho.
}
\examples{
str(calibrations)
}
\keyword{datasets}
