% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Estimation_allmodels_withlmekin.r
\name{Estimation_allmodels}
\alias{Estimation_allmodels}
\title{Compute estimated effects}
\usage{
Estimation_allmodels(Y, selec_XXclass, KK, cofs = NULL, female = NULL,
  male = NULL)
}
\arguments{
\item{Y}{A numeric named vector where the names are individuals names and the values their phenotype. The names of Y will be matched to the row names of X.}

\item{selec_XXclass}{A n by mk data.frame of factors
with rownames()=individual names, and colnames()=mk selected SNP names
additive+dominance: three levels factor
female+male+interaction: four levels factor

Use function \code{\link{fromeBICtoEstimation}} to get this armument.}

\item{KK}{a list of one, two or three matrices depending on the models

- additive: a n by n matrix, where n=number of individuals, with rownames()=colnames()=individual names

- additive+dominance: two n by n matrices, where n=number of individuals, with rownames()=colnames()=individual names

- female+male: a n.female by n.female matrix, with rownames()=colnames()=female names and a n.male by n.male matrix, with rownames()=colnames()=male names

- female+male+interaction: the same two matrices as the model female+male and a n by n matrix, where n=number of individuals, with rownames()=colnames()=individual names}

\item{cofs}{A n by q matrix, where n=number of individuals, q=number of fixed effect, with rownames()=individual names and with column names, forbidden head of column names for this matrix "eff1_" and usage of special characters as "*","/","&"}

\item{female}{A factor of levels female names and length n, only for the last two models}

\item{male}{A factor of levels male names and length n, only for the last two models}
}
\value{
A dataframe with 3 colum: BLUE, Tukey.Class and Frequency. The firt line name is "mu", the names of the other lines are in the form markername_allele.
}
\description{
Estimate the effect of selected SNPs.
}
\examples{
### Additive model ###
\dontrun{
data("mlmm.gwas.AD")

XX = list(Xa)
KK = list(K.add)

# GWAS
res_mlmm <- mlmm_allmodels(floweringDateAD, XX, KK)
manhattan.plot(res_mlmm)

# Model selection
sel_XX <- frommlmm_toebic(XX, res_mlmm)
res.eBIC <- eBIC_allmodels(floweringDateAD, sel_XX, KK, ncol(Xa))

# Effects estimations with the selected model
sel_XXclass <- fromeBICtoEstimation(sel_XX, res.eBIC)
eff.estimations <- Estimation_allmodels(floweringDateAD, sel_XXclass, KK)
genotypes.boxplot(Xa, floweringDateAD, effects = eff.estimations)
}

### Additive + dominance model
\dontrun{
data("mlmm.gwas.AD")

XX = list(Xa, Xd)
KK = list(K.add, K.dom)

# GWAS
res_mlmm <- mlmm_allmodels(floweringDateAD, XX, KK)
manhattan.plot(res_mlmm)

# Model selection
sel_XX <- frommlmm_toebic(XX, res_mlmm)
res.eBIC <- eBIC_allmodels(floweringDateAD, sel_XX, KK, ncol(Xa))
#the selected model is the null model
}


### Female+Male model
\dontrun{
data("mlmm.gwas.FMI")

XX = list(Xf, Xm)
KK = list(K.female, K.male)

# GWAS
res_mlmm <- mlmm_allmodels(floweringDateFMI, XX, KK, female = female, male = male)
manhattan.plot(res_mlmm)

# Model selection
sel_XX <- frommlmm_toebic(XX, res_mlmm)
res.eBIC <- eBIC_allmodels(floweringDateFMI, sel_XX, KK, ncol(Xf), female = female, male = male)
#the selected model is the null model
}



### Female+Male+Interaction model
\dontrun{
data("mlmm.gwas.FMI")

XX = list(Xf, Xm, Xfm)
KK = list(K.female, K.male, K.hybrid)

# GWAS
res_mlmm <- mlmm_allmodels(floweringDateFMI, XX, KK, female = female, male = male)
manhattan.plot(res_mlmm)

# Model selection
sel_XX <- frommlmm_toebic(XX, res_mlmm)
res.eBIC <- eBIC_allmodels(floweringDateFMI, sel_XX, KK, ncol(Xf), female = female, male = male)
#the selected model is the null model
}
}
