% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MizerParams-class.R
\name{setLinetypes}
\alias{setLinetypes}
\alias{getLinetypes}
\title{Set linetypes to be used in mizer plots}
\usage{
setLinetypes(params, linetypes)

getLinetypes(params)
}
\arguments{
\item{params}{A MizerParams object}

\item{linetypes}{A named list or named vector of linetypes.}
}
\value{
The MizerParams object with updated linetypes
}
\description{
Linetypes for names that already had a linetype set will be overwritten by
the linetype you specify. Linetypes for names that did not yet have a
linetype will be appended to the list of linetypes.
}
\examples{
params <- NS_params
params <- setLinetypes(params, list("Cod" = "solid"))
plotSpectra(params)
getLinetypes(params)
}
