% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_methods.R
\name{getGrowthCurves}
\alias{getGrowthCurves}
\title{Get growth curves giving weight as a function of age}
\usage{
getGrowthCurves(object, species = NULL, max_age = 20, percentage = FALSE)
}
\arguments{
\item{object}{MizerSim or MizerParams object. If given a
\linkS4class{MizerSim} object, uses the growth rates at the final time of a
simulation to calculate the size at age. If given a
\linkS4class{MizerParams} object, uses the initial growth rates instead.}

\item{species}{The species to be selected. Optional. By default all target
species are selected. A vector of species names, or a
numeric vector with the species indices, or a logical vector indicating for
each species whether it is to be selected (TRUE) or not.}

\item{max_age}{The age up to which to run the growth curve. Default is 20.}

\item{percentage}{Boolean value. If TRUE, the size is given as a percentage
of the maximal size.}
}
\value{
An array (species x age) containing the weight in grams.
}
\description{
Get growth curves giving weight as a function of age
}
\examples{
growth_curves <- getGrowthCurves(NS_params, species = c("Cod", "Haddock"))
str(growth_curves)

library(ggplot2)
ggplot(melt(growth_curves)) +
  geom_line(aes(Age, value)) +
  facet_wrap(~ Species, scales = "free") +
  ylab("Size[g]") + xlab("Age[years]")
}
\seealso{
Other summary functions: 
\code{\link{getBiomass}()},
\code{\link{getDiet}()},
\code{\link{getN}()},
\code{\link{getSSB}()},
\code{\link{getYieldGear}()},
\code{\link{getYield}()}
}
\concept{summary functions}
