% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manipulate_species.R
\name{addSpecies}
\alias{addSpecies}
\title{Add new species}
\usage{
addSpecies(
  params,
  species_params,
  gear_params = data.frame(),
  initial_effort,
  interaction
)
}
\arguments{
\item{params}{A mizer params object for the original system.}

\item{species_params}{Data frame with the species parameters of the new
species we want to add to the system.}

\item{gear_params}{Optional data frame with the gear parameters for the new
species.}

\item{initial_effort}{A named vector with the effort for new fishing gear
introduced in \code{gear_params}. Only needed if new gear are introduced, not
if the new species are fished only by existing gear.}

\item{interaction}{Interaction matrix. A square matrix giving either the
interaction coefficients between all species or only those between the
new species. In the latter case all interaction between an old and a new
species are set to 1. If this argument is missing, all interactions
involving a new species are set to 1.}
}
\value{
An object of type \linkS4class{MizerParams}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Takes a \linkS4class{MizerParams} object and adds additional species with
given parameters to the ecosystem. It sets the initial values for these new
species to their steady-state solution in the given initial state of the
existing ecosystem. This will be close to the true steady state if the
abundances of the new species are sufficiently low. Hence the abundances of
the new species are set so that the maximal biomass density of each new
species lies at 1/100 of the community power law. The reproductive
efficiencies of the new species are set so as to keep them at that low level.
}
\details{
The resulting MizerParams object will use the same size grid where possible,
but if one of the new species needs a larger range of w (either because
a new species has an egg size smaller than those of existing species or
a maximum size larger than those of existing species) then the grid will
be expanded and all arrays will be enlarged accordingly.

If any of the rate arrays had been set by the user to values other than
those calculated as default from the species parameters, then these will
be preserved.

After adding the new species, the background species are not retuned and the
system is not run to steady state.
}
\examples{
\dontrun{
params <- newTraitParams()
a_m <- 0.0085
b_m <- 3.11
L_inf_m <- 24.3
L_mat <- 11.1
species_params <- data.frame(
    species = "mullet",
    w_min = 0.001,
    w_inf = a_m*L_inf_m^b_m,
    w_mat = a_m*L_mat^b_m,
    beta = 283,
    sigma = 1.8,
    z0 = 0,
    alpha = 0.6,
    sel_func = "knife_edge",
    knife_edge_size = 100,
    gear = "knife_edge_gear",
    k = 0,
    k_vb = 0.6,
    a = a_m,
    b = b_m
)
params <- addSpecies(params, species_params)
plotSpectra(params)
sim <- project(params, t_max=50, progress_bar = FALSE)
plotBiomass(sim)
}
}
\seealso{
\code{\link[=removeSpecies]{removeSpecies()}}
}
