## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## -----------------------------------------------------------------------------
x <- c(0, 0, 0, 1, 1, 1)
library(mixvlmc)
x_ctx <- ctx_tree(x)
x_ctx

## -----------------------------------------------------------------------------
draw(x_ctx)

## -----------------------------------------------------------------------------
set.seed(0)
y <- sample(c("a", "b", "c"), 100, replace = TRUE)
y_ctx_def <- ctx_tree(y)
y_ctx_def

## -----------------------------------------------------------------------------
y_ctx_min_1 <- ctx_tree(y, min_size = 1)
y_ctx_min_1

## -----------------------------------------------------------------------------
y_ctx_min_1_d_15 <- ctx_tree(y, min_size = 1, max_depth = 15)
y_ctx_min_1_d_15

## -----------------------------------------------------------------------------
contexts(x_ctx)

## -----------------------------------------------------------------------------
contexts(x_ctx, frequency = "total")

## -----------------------------------------------------------------------------
contexts(x_ctx, frequency = "detailed")

## -----------------------------------------------------------------------------
node_aaa <- find_sequence(y_ctx_min_1, c("a", "a", "a"))
node_aaa

## -----------------------------------------------------------------------------
is_context(node_aaa)

## -----------------------------------------------------------------------------
children(node_aaa)

## -----------------------------------------------------------------------------
counts(node_aaa, frequency = "total")

## -----------------------------------------------------------------------------
counts(node_aaa, frequency = "detailed")

## -----------------------------------------------------------------------------
positions(node_aaa)

