-----------------------------------

## An Extended Mixed-Effects Modelling Framework for Meta-Analysis

The package consists of a collection of functions to perform various meta-analytical models within a unified mixed-effects framework, including standard univariate fixed and random-effects meta-analysis and meta-regression, and non-standard extensions such as multivariate, multilevel, longitudinal, and dose-response models. The methodology is illustrated in detail in the article by Sera \& Gasparrini (see below).

### Info on the `mixmeta` package

The package `mixmeta` is available on the Comprehensive R Archive Network (CRAN), with info at the related web page (https://cran.r-project.org/package=mixmeta). A development website is available on GitHub (https://github.com/gasparrini/mixmeta).

For a short summary of the functionalities of this package, refer to the main help page by typing:

```r
help(package="mixmeta")
```

in R after installation (see below).

### Installation

The last version officially released on CRAN can be installed directly within R by typing:

```r
install.packages("mixmeta")
```

### R code in published articles

Several peer-reviewed articles and documents provide R code illustrating methodological developments of `mixmeta` or replicating substantive results using this package. An updated version of the code can be found at the GitHub (https://github.com/gasparrini) or personal web page (http://www.ag-myresearch.com) of the package maintainer.

### References:

Sera F, Gasparrini A. An extended mixed-eﬀects framework for meta-analysis. *Statistics in Medicine*. 2019; In submission.
