% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/viz_functions.R
\name{vizMem}
\alias{vizMem}
\title{Mixed Membership Visualization}
\usage{
vizMem(model, compare = NULL, main = "Estimated Membership", nrow = NULL,
  ncol = NULL, indices = NULL, groupNames = NULL, fitNames = NULL)
}
\arguments{
\item{model}{the \code{mixedMemModel} object that will be plotted.}

\item{compare}{a matrix of the same dimensions as \code{model$phi} which contains parameters to compare
against the fitted model.}

\item{main}{the main figure title.}

\item{nrow}{the number of rows in each plot.}

\item{ncol}{the number of columns in each plot.}

\item{indices}{the specific individuals which will be shown in the plot. If the argument is left blank, all individuals will be plotted.
If the number of individuals to be plotted is larger than \code{nrow * ncol} then multiple plots will be produced.}

\item{groupNames}{a vector specifying labels for each sub-population.}

\item{fitNames}{a vector of length 2 containing strings which correspond to the names of the models (fitted and comparison).}
}
\description{
\code{vizMem} plots estimates for the group membership scores of each individual. This is the function called by the \code{mixedMemModel} class
generic plot function.
}
\details{
The estimates plotted are the normalized \eqn{\phi}, which are the posterior means from the variational distribution. The
estimated group membership scores are  shown in black, and the estimates from a comparison model (if available) are shown in red. Each plot
represents an individual.

This is the function called by the plot generic function for mixedMemModel objects.
}

