% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/df.duplicated.R
\name{df.duplicated}
\alias{df.duplicated}
\alias{df.unique}
\title{Extract Duplicated or Unique Rows}
\usage{
df.duplicated(..., data, first = TRUE, keep.all = TRUE, from.last = FALSE,
              keep.row.names = TRUE, check = TRUE)

df.unique(..., data, keep.all = TRUE, from.last = FALSE,
          keep.row.names = TRUE, check = TRUE)
}
\arguments{
\item{...}{an expression indicating the variable names in \code{data}
used to determine duplicated or unique rows.e.g.,
\code{df.duplicated(x1, x2, data = dat)}. Note that the
operators \code{.}, \code{+}, \code{-}, \code{~}, \code{:},
\code{::}, and \code{!} can also be used to select
variables, see Details in the \code{\link{df.subset}}
function.}

\item{data}{a data frame.}

\item{first}{logical: if \code{TRUE} (default), the \code{df.duplicated()}
function will return duplicated rows including the first of identical
rows.}

\item{keep.all}{logical: if \code{TRUE} (default), the function will return all
variables in \code{x} after extracting duplicated or unique rows based
on the variables specified in the argument \code{...}.}

\item{from.last}{logical: if \code{TRUE}, duplication will be considered
from the reversed side, i.e., the last of identical rows
would correspond to \code{duplicated = FALSE}.
Note that this argument is only used when \code{first = FALSE}.}

\item{keep.row.names}{logical: if \code{TRUE} (default), the row names from \code{x} are kept,
otherwise they are set to \code{NULL}.}

\item{check}{logical: if \code{TRUE} (default), argument specification is checked.}
}
\value{
Returns duplicated or unique rows of the data frame in \code{...} or \code{data}.
}
\description{
The function \code{df.duplicated} extracts duplicated rows and the function
\code{df.unique} extracts unique rows from a matrix or data frame.
}
\details{
Note that \code{df.unique(x)} is equivalent to \code{unique(x)}. That is, the
main difference between the \code{df.unique()} and the \code{unique()} function is
that the \code{df.unique()} function provides the \code{...} argument to
specify a variable or multiple variables which are used to determine unique rows.
}
\examples{
dat <- data.frame(x1 = c(1, 1, 2, 1, 4),
                  x2 = c(1, 1, 2, 1, 6),
                  x3 = c(2, 2, 3, 2, 6),
                  x4 = c(1, 1, 2, 2, 4),
                  x5 = c(1, 1, 4, 4, 3))

#-------------------------------------------------------------------------------
# df.duplicated() function

# Example 1: Extract duplicated rows based on all variables
df.duplicated(., data = dat)

# Example 2: Extract duplicated rows based on x4
df.duplicated(x4, data = dat)

# Example 3: Extract duplicated rows based on x2 and x3
df.duplicated(x2, x3, data = dat)

# Example 4: Extract duplicated rows based on all variables
# exclude first of identical rows
df.duplicated(., data = dat, first = FALSE)

# Example 5: Extract duplicated rows based on x2 and x3
# do not return all variables
df.duplicated(x2, x3, data = dat, keep.all = FALSE)

# Example 6: Extract duplicated rows based on x4
# consider duplication from the reversed side
df.duplicated(x4, data = dat, first = FALSE, from.last = TRUE)

# Example 7: Extract duplicated rows based on x2 and x3
# set row names to NULL
df.duplicated(x2, x3, data = dat, keep.row.names = FALSE)

#-------------------------------------------------------------------------------
# df.unique() function

# Example 8: Extract unique rows based on all variables
df.unique(., data = dat)

# Example 9: Extract unique rows based on x4
df.unique(x4, data = dat)

# Example 10: Extract unique rows based on x1, x2, and x3
df.unique(x1, x2, x3, data = dat)

# Example 11: Extract unique rows based on x2 and x3
# do not return all variables
df.unique(x2, x3, data = dat, keep.all = FALSE)

# Example 12: Extract unique rows based on x4
# consider duplication from the reversed side
df.unique(x4, data = dat, from.last = TRUE)

# Example 13: Extract unique rows based on x2 and x3
# set row names to NULL
df.unique(x2, x3, data = dat, keep.row.names = FALSE)
}
\references{
Becker, R. A., Chambers, J. M. and Wilks, A. R. (1988) \emph{The New S Language}.
Wadsworth & Brooks/Cole.
}
\seealso{
\code{\link{df.merge}},
\code{\link{df.move}}, \code{\link{df.rbind}},
\code{\link{df.rename}}, \code{\link{df.sort}},
\code{\link{df.subset}}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
