% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.na.R
\name{as.na}
\alias{as.na}
\title{Replace User-Specified Values With Missing Values}
\usage{
as.na(x, na, check = TRUE)
}
\arguments{
\item{x}{a vector, factor, matrix, array, data frame, or list.}

\item{na}{a vector indicating values or characters to replace with \code{NA}.}

\item{check}{logical: if \code{TRUE}, argument specification is checked.}
}
\value{
Returns \code{x} with values specified in \code{na} replaced with \code{NA}.
}
\description{
This function replaces user-specified values in the argument \code{as.na} in
a vector, factor, matrix, array, list, or data frame with \code{NA}.
}
\examples{
#--------------------------------------
# Numeric vector
x.num <- c(1, 3, 2, 4, 5)

# Replace 2 with NA
as.na(x.num, na = 2)

# Replace 2, 3, and 4 with NA
as.na(x.num, na = c(2, 3, 4))

#--------------------------------------
# Character vector
x.chr <- c("a", "b", "c", "d", "e")

# Replace "b" with NA
as.na(x.chr, na = "b")

# Replace "b", "c", and "d" with NA
as.na(x.chr, na = c("b", "c", "d"))

#--------------------------------------
# Factor
x.factor <- factor(c("a", "a", "b", "b", "c", "c"))

# Replace "b" with NA
as.na(x.factor, na = "b")

# Replace "b" and "c" with NA
as.na(x.factor, na = c("b", "c"))

#--------------------------------------
# Matrix
x.mat <- matrix(1:20, ncol = 4)

# Replace 8 with NA
as.na(x.mat, na = 8)

# Replace 8, 14, and 20 with NA
as.na(x.mat, na = c(8, 14, 20))

#--------------------------------------
# Array
x.array <- array(1:20,dim = c(2, 3, 2))

# Replace 1 and 10 with NA
as.na(x.array, na = c(1, 10))

#--------------------------------------
# Data frame
x.df <- data.frame(x1 = c(1, 2, 3),
                   x2 = c(2, 1, 3),
                   x3 = c(3, 1, 2), stringsAsFactors = FALSE)

# Replace 1 with NA
as.na(x.df, na = 1)

# Replace 1 and 3 with NA
as.na(x.df, na = c(1, 3))

#--------------------------------------
# List
x.list <- list(x1 = c(1, 2, 3, 1, 2, 3),
               x2 = c(2, 1, 3, 2, 1),
               x3 = c(3, 1, 2, 3))

# Replace 1 with NA
as.na(x.list, na = 1)
}
\references{
Becker, R. A., Chambers, J. M. and Wilks, A. R. (1988) \emph{The New S Language}.
Wadsworth & Brooks/Cole.
}
\seealso{
\code{\link{na.as}}, \code{\link{na.auxiliary}}, \code{\link{na.coverage}},
\code{\link{na.descript}}, \code{\link{na.indicator}}, \code{\link{na.pattern}},
\code{\link{na.prop}}, \code{\link{na.test}}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
