% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descript.R
\name{descript}
\alias{descript}
\title{Descriptive Statistics}
\usage{
descript(x,
        print = c("all", "n", "nNA", "pNA", "m", "se.m", "var", "sd", "min",
                  "p25", "med", "p75", "max", "range", "iqr", "skew", "kurt"),
        group = NULL, split = NULL, sort.var = FALSE, na.omit = FALSE,
        digits = 2, as.na = NULL, write = NULL, check = TRUE, output = TRUE)
}
\arguments{
\item{x}{a numeric vector, matrix or data frame with numeric variables, i.e.,
factors and character variables are excluded from \code{x} before conducting the analysis.}

\item{print}{a character vector indicating which statistical measures to be printed on the console,
i.e. \code{n} (number of observations), \code{nNA} (number of missing values),
\code{pNA} (percentage of missing values), \code{m} (arithmetic mean),
\code{se.m} (standard error of the arithmetic mean), \code{var} (variance),
\code{sd} (standard deviation), \code{med} (median),\code{min} (minimum),
\code{p25} (25th percentile, first quartile), \code{p75} (75th percentile, third quartile),
\code{max} (maximum),  \code{range} (range), \code{iqr} (interquartile range),
\code{skew} (skewness), and \code{kurt} (excess kurtosis).
The default setting is \code{print = ("n", "nNA", "pNA", "m", "sd", "min", "max", "skew", "kurt")}.}

\item{group}{a numeric vector, character vector or factor as grouping variable.}

\item{split}{a numeric vector, character vector or factor as split variable.}

\item{sort.var}{logical: if \code{TRUE}, output table is sorted by variables when specifying \code{group}.}

\item{na.omit}{logical: if \code{TRUE}, incomplete cases are removed before conducting the analysis
(i.e., listwise deletion).}

\item{digits}{an integer value indicating the number of decimal places to be used.}

\item{as.na}{a numeric vector indicating user-defined missing values,
i.e. these values are converted to \code{NA} before conducting the analysis.
Note that \code{as.na()} function is only applied to \code{x}, but
not to \code{group} or \code{split}.}

\item{write}{a character string for writing the results into a Excel file naming a file with or without file extension '.xlsx', e.g., \code{"Results.xlsx"} or \code{"Results"}.}

\item{check}{logical: if \code{TRUE}, argument specification is checked.}

\item{output}{logical: if \code{TRUE}, output is shown on the console.}
}
\value{
Returns an object of class \code{misty.object}, which is a list with following entries:
function call (\code{call}), type of analysis \code{type}, matrix or data frame specified in
\code{x} (\code{data}), specification of function arguments (\code{args}), and
list with results (\code{result}).
}
\description{
This function computes summary statistics for one or more variables, optionally by a grouping and/or split variable.
}
\examples{
dat <- data.frame(group1 = c(1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2),
                  group2 = c(1, 1, 1, 2, 2, 2, 1, 1, 1, 2, 2, 2),
                  x1 = c(3, 1, 4, 2, 5, 3, 2, 4, NA, 4, 5, 3),
                  x2 = c(4, NA, 3, 6, 3, 7, 2, 7, 5, 1, 3, 6),
                  x3 = c(7, 8, 5, 6, 4, NA, 8, NA, 6, 5, 8, 6))

# Descriptive statistics for x1
descript(dat$x1)

# Descriptive statistics for x1, print results with 3 digits
descript(dat$x1, digits = 3)

# Descriptive statistics for x1, convert value 4 to NA
descript(dat$x1, as.na = 4)

# Descriptive statistics for x1, print all available statistical measures
descript(dat$x1, print = "all")

# Descriptive statistics for x1, x2, and x3
descript(dat[, c("x1", "x2", "x3")])

# Descriptive statistics for x1, x2, and x3,
# listwise deletion for missing data
descript(dat[, c("x1", "x2", "x3")], na.omit = TRUE)

# Descriptive statistics for x1, x2, and x3,
# analysis by group1 separately
descript(dat[, c("x1", "x2", "x3")], group = dat$group1)

# Descriptive statistics for x1, x2, and x3,
# analysis by group1 separately, sort by variables
descript(dat[, c("x1", "x2", "x3")], group = dat$group1, sort.var = TRUE)

# Descriptive statistics for x1, x2, and x3,
# split analysis by group1
descript(dat[, c("x1", "x2", "x3")], split = dat$group1)

# Descriptive statistics for x1, x2, and x3,
# analysis by group1 separately, split analysis by group2
descript(dat[, c("x1", "x2", "x3")], group = dat$group1, split = dat$group2)

\dontrun{
# Write Results into a Excel file
descript(dat[, c("x1", "x2", "x3")], write = "Descript.xlsx")

result <- descript(dat[, c("x1", "x2", "x3")], output = FALSE)
write.result(result, "Descript.xlsx") }
}
\references{
Rasch, D., Kubinger, K. D., & Yanagida, T. (2011). \emph{Statistics in psychology - Using R and SPSS}.
John Wiley & Sons.
}
\seealso{
\code{\link{ci.mean}}, \code{\link{ci.mean.diff}}, \code{\link{ci.median}}, \code{\link{ci.prop}},
\code{\link{ci.prop.diff}}, \code{\link{ci.var}}, \code{\link{ci.sd}}, \code{\link{freq}},
\code{\link{crosstab}},  \code{\link{multilevel.descript}}, \code{\link{na.descript}}.
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
