% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compdist.R, R/mixdist.R, R/standist.R,
%   R/trans_standist.R
\name{p.compdist}
\alias{p.compdist}
\alias{p.mixdist}
\alias{p}
\alias{p.standist}
\alias{p.trans_univdist}
\title{Distribution Function}
\usage{
\method{p}{compdist}(O, q, lower.tail = TRUE, log.p = FALSE)

\method{p}{mixdist}(O, q, lower.tail = TRUE, log.p = FALSE)

p(O, q, lower.tail = TRUE, log.p = FALSE)

\method{p}{standist}(O, q, lower.tail = TRUE, log.p = FALSE)

\method{p}{trans_univdist}(O, q, lower.tail = TRUE, log.p = FALSE)
}
\arguments{
\item{O}{distribution object.}

\item{q}{vector of quantiles.}

\item{lower.tail}{logical; if TRUE, probabilities are \eqn{P[X \le x]} otherwise, \eqn{P[X > x]}, default: TRUE.}

\item{log.p}{logical; if TRUE, probabilities \eqn{p} are given as \eqn{log(p)}, default: FALSE.}
}
\value{
Vector of computed results.
}
\description{
\code{p} is a generic function that evaluates the distribution function of a distribution object at given values.
}
\details{
Methods of \code{p} function evaluates any offered
         distribution from the package \code{\link{mistr}}. The function makes use of the p[sufix] functions
         as \code{pnorm} or \code{pbeta} and thus, if a new distribution is added,
         these functions must be reachable through the search path.
}
\examples{
N <- normdist(1,3)
p(N, c(NA,1,3,5))

C <- cauchydist()
M <- mixdist(N, C, weights = c(0.5, 0.5))
p(M, c(NA,1,3,5))

CC <- compdist(N, C, weights = c(0.5, 0.5), breakpoints = 1)
CCC <- 2*C+5
p(CCC, c(NA,1,3,5))
}
