% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LRage.R
\name{LRage}
\alias{LRage}
\title{Likelihood ratio for age variable}
\usage{
LRage(
  MPa = 40,
  MPr = 6,
  UHRr = 1,
  gam = 0.07,
  nsims = 1000,
  epa = 0.05,
  erRa = epa,
  H = 1,
  modelA = c("uniform", "custom")[1],
  LR = FALSE
)
}
\arguments{
\item{MPa}{Missing person age}

\item{MPr}{Missing person age range.}

\item{UHRr}{Unidentified person range}

\item{gam}{Simulation parameter for UHR ages.}

\item{nsims}{number of simulations.}

\item{epa}{epsilon age}

\item{erRa}{error rate in the database.}

\item{H}{hipothesis tested, H1: UHR is MP, H2: UHR is not MP.}

\item{modelA}{reference database probabilities, uniform assumes equally probable ages. Custom needs a vector with ages frequencies.}

\item{LR}{compute LR values}
}
\value{
A value of Likelihood ratio based on preliminary investigation data. In this case, Age.
}
\description{
Likelihood ratio for age variable
}
