% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{secondOrderTest}
\alias{secondOrderTest}
\title{Second-order test of convergence}
\usage{
secondOrderTest(mat, ..., method = "eigen")
}
\arguments{
\item{mat}{symmetric matrix to test for positive definiteness (typically the Hessian at the
highest point of model estimator, such as MLE or MAP)}

\item{...}{arguments passed to either \code{\link{eigen}}, \code{\link{chol}}, or
\code{'det'} for the positiveness of the eigen values, positiveness of leading minors
via the Cholesky decomposition, or evaluation of whether the determinant
is greater than 0}

\item{method}{method to use to test positive definiteness. Default is \code{'eigen'}}
}
\value{
a matrix with all possible combinations
}
\description{
Test whether terminated estimation criteria for a given model passes
the second order test by checking the positive definiteness of the resulting
Hessian matrix. This function, which accepts the symmetric Hessian/information
matrix as the input, returns \code{TRUE} if the matrix is positive definite
and \code{FALSE} otherwise.
}
\examples{

\dontrun{

# PD matrix
mod <- mirt(Science, 1, SE=TRUE)
info <- solve(vcov(mod))   ## observed information
secondOrderTest(info)
secondOrderTest(info, method = 'chol')
secondOrderTest(info, method = 'det')

# non-PD matrix
mat <- matrix(c(1,0,0,0,1,1,0,1,1), ncol=3)
mat
secondOrderTest(mat)
secondOrderTest(mat, method = 'chol')
secondOrderTest(mat, method = 'det')

}
}
\references{
Chalmers, R., P. (2012). mirt: A Multidimensional Item Response Theory
Package for the R Environment. \emph{Journal of Statistical Software, 48}(6), 1-29.
\doi{10.18637/jss.v048.i06}
}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
