% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/daemons.R
\name{require_daemons}
\alias{require_daemons}
\title{Require Daemons}
\usage{
require_daemons(.compute = NULL, call = environment())
}
\arguments{
\item{.compute}{[default NULL] character value for the compute profile
to use (each has its own independent set of daemons), or NULL to use the
'default' profile.}

\item{call}{(only used if the \CRANpkg{cli} package is installed) the
execution environment of a currently running function, e.g.
\code{environment()}. The function will be mentioned in error messages as the
source of the error.}
}
\value{
Logical \code{TRUE}, or else errors.
}
\description{
Returns TRUE only if daemons are set, otherwise produces an informative
error for the user to set daemons, with a clickable function link if the
\CRANpkg{cli} package is available.
}
\note{
Previously the arguments were reversed with \code{call} coming before \code{.compute}.
Specifying an environment to the first argument works for the time being,
although is deprecated and will be defunct in a future version.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
daemons(1)
require_daemons()
daemons(0)
\dontshow{\}) # examplesIf}
}
