% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mirai.R
\name{eval_mirai}
\alias{eval_mirai}
\title{Eval mirai (Evaluate Async)}
\usage{
eval_mirai(.expr, ...)
}
\arguments{
\item{.expr}{an expression to evaluate in a new R process.}

\item{...}{named arguments specifying the variables contained in 'expr'.}
}
\value{
A 'mirai' object.
}
\description{
Evaluate an expression asynchronously in a new non-blocking R process. This
    function will return immediately with a mirai, which can be called for
    the result.
}
\details{
This function will return immediately. To call the result, use
    \code{\link{call_mirai}} on the returned 'mirai' object.

    The expression '.expr' will be evaluated in a new R process in a clean
    environment consisting of the named objects passed as '...' only.
}
\examples{
if (interactive()) {
# Only run examples in interactive R sessions

mirai <- eval_mirai(x + y + 1, x = 2, y = 3)
mirai
call_mirai(mirai)
mirai
mirai$value

mirai <- eval_mirai(as.matrix(df), df = data.frame())
call_mirai(mirai)$value

mirai <- eval_mirai(rnorm(n), n = 1e6)
call_mirai(mirai)
str(mirai$value)
}

}
