% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/separately.R
\name{tree}
\alias{tree}
\title{Draw a mindmap of a directory}
\usage{
tree(
  from = ".",
  to = NULL,
  root = NA,
  show_files = FALSE,
  widget_name = NA,
  width = NULL,
  height = NULL,
  elementId = NULL,
  options = markmapOption(preset = "colorful")
)
}
\arguments{
\item{from}{character. TThe path to the directory.}

\item{to}{character. The path of the output file.}

\item{root}{character. a string displayed as the root of the mind map}

\item{show_files}{logical. Whether to show files in a directory.}

\item{widget_name}{The file name of the html widget to save.}

\item{width}{the width of the markmap}

\item{height}{the height of the markmap}

\item{elementId}{character.}

\item{options}{the markmap options}
}
\value{
A HTML widget object rendered from a given document.
}
\description{
Draw a mindmap of a directory
}
\examples{
\dontrun{
tree()
input <- system.file(package = "mindr")
tree(input)
tree(input, root = "mindr", show_files = TRUE)
tree(input, root = "mindr", show_files = TRUE, to = "mindr.mm")
tree(input, root = "mindr", show_files = TRUE, to = "mindr.md")
tree(input, root = "mindr", show_files = TRUE, to = "mindr.txt")
}
}
