% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_string_generation.R
\name{generate_snp_search_string}
\alias{generate_snp_search_string}
\title{\code{generate_snp_search_string}}
\usage{
generate_snp_search_string(
  selected_snps,
  position_reference,
  ref_seq,
  snp_matrix,
  prev,
  after,
  position_type = "fasta",
  extend_length = TRUE,
  fasta_name_as_result = TRUE,
  bp = MulticoreParam()
)
}
\arguments{
\item{selected_snps}{list of targeted SNPs}

\item{position_reference}{the mapping between
reference genome positions and orthologous SNP matrix positions}

\item{ref_seq}{the reference genome sequence}

\item{snp_matrix}{the orthologous SNP matrix}

\item{prev}{number of characters before the SNP}

\item{after}{number of characters after the SNP}

\item{position_type}{type of SNPs input, "fasta"
(orthologous SNP matrix based) or "genome"
(reference genome based); Default to "fasta"}

\item{extend_length}{whether to extend the search string
before and after the SNP and ignore overlapping SNPs}

\item{fasta_name_as_result}{Whether the result should use 
the fasta matching sequence name or the fasta position and allele,
default to using fasta sequence name (TRUE)}

\item{bp}{BiocParallel backend to use}
}
\value{
a dataframe containing the search strings
}
\description{
\code{generate_snp_search_string} identify the SNPs that will overlap
the search strings generated from the targeted SNPs
}
