% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_predict.R
\name{predict}
\alias{predict}
\alias{predict.netlm}
\alias{predict.netlogit}
\title{Predict methods for network regression}
\usage{
\method{predict}{netlm}(object, newdata = NULL, ...)

\method{predict}{netlogit}(object, newdata = NULL, type = c("link", "response"), ...)
}
\arguments{
\item{object}{An object of class inheriting "netlm" or "netlogit"}

\item{newdata}{A design matrix with the same columns/variables as the
fitted model.}

\item{...}{Additional arguments (not used).}

\item{type}{Character string, one of "response"
(default, whether the returned predictions are on the probability scale)
or "link" (returned predictions are on the scale of the linear predictor).}
}
\value{
A numeric vector of predicted values.
}
\description{
Predict methods for network regression
}
\examples{
networkers <- ison_networkers \%>\% to_subgraph(Discipline == "Sociology")
model1 <- net_regression(weight ~ ego(Citations) + alter(Citations) + sim(Citations), 
                      networkers, times = 20)
predict(model1, matrix(c(1,10,5,2),1,4))
networkers <- ison_networkers \%>\% to_subgraph(Discipline == "Sociology") \%>\% 
  to_unweighted()
model1 <- net_regression(. ~ ego(Citations) + alter(Citations) + sim(Citations), 
                      networkers, times = 20)
predict(model1, matrix(c(1,10,5,2),1,4))
}
