% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measure_features.R
\name{periods}
\alias{periods}
\alias{network_change}
\alias{network_stability}
\title{Measures of network change}
\usage{
network_change(.data, object2)

network_stability(.data, object2)
}
\arguments{
\item{.data}{An object of a \code{{manynet}}-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}

\item{object2}{A network object.}
}
\description{
These functions measure certain topological features of networks:
\itemize{
\item \code{network_change()} measures the Hamming distance between two or more networks.
\item \code{network_stability()} measures the Jaccard index of stability between two or more networks.
}

These \verb{network_*()} functions return a numeric vector the length of the number
of networks minus one. E.g., the periods between waves.
}
\seealso{
Other measures: 
\code{\link{between_centrality}},
\code{\link{close_centrality}},
\code{\link{closure}},
\code{\link{cohesion}()},
\code{\link{degree_centrality}},
\code{\link{eigenv_centrality}},
\code{\link{features}},
\code{\link{heterogeneity}},
\code{\link{hierarchy}},
\code{\link{holes}},
\code{\link{net_diffusion}},
\code{\link{node_diffusion}}
}
\concept{measures}
