% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measure_over.R
\name{over}
\alias{over}
\alias{over_waves}
\alias{over_time}
\title{Helper functions for measuring over splits of networks}
\usage{
over_waves(
  .data,
  FUN,
  ...,
  attribute = "wave",
  strategy = "sequential",
  verbose = FALSE
)

over_time(
  .data,
  FUN,
  ...,
  attribute = "time",
  slice = NULL,
  strategy = "sequential",
  verbose = FALSE
)
}
\arguments{
\item{.data}{An object of a \code{{manynet}}-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}

\item{FUN}{A function to run over all splits.}

\item{...}{Further arguments to be passed on to FUN.}

\item{attribute}{A string naming the attribute to be split upon.}

\item{strategy}{If \code{{furrr}} is installed,
then multiple cores can be used to accelerate the function.
By default \code{"sequential"},
but if multiple cores available,
then \code{"multisession"} or \code{"multicore"} may be useful.
Generally this is useful only when \code{times} > 1000.
See \href{https://furrr.futureverse.org}{\code{{furrr}}} for more.}

\item{verbose}{Whether the function should report on its progress.
By default FALSE.
See \href{https://progressr.futureverse.org}{\code{{progressr}}} for more.}

\item{slice}{Optionally, a vector of specific slices.
Otherwise all observed slices will be returned.}
}
\description{
Helper functions for measuring over splits of networks
}
\section{Functions}{
\itemize{
\item \code{over_waves()}: Runs a function, e.g. a measure,
over waves of a panel network

\item \code{over_time()}: Runs a function, e.g. a measure,
over time slices of a dynamic network

}}
