% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{graph_clustering}
\alias{graph_clustering}
\title{Clustering for one-, two-, and three- mode networks}
\usage{
graph_clustering(object, object2 = NULL)
}
\arguments{
\item{object}{A one-mode or two-mode matrix, igraph, or tidygraph}

\item{object2}{Optionally, a second (two-mode) matrix, igraph, or tidygraph}
}
\description{
This function offers clustering methods for one-, two-, and three-mode networks.
}
\details{
For one-mode networks, the function serves as a shallow wrapper for \code{igraph::transitivity},
since global transitivity is a regular measure for clustering or local density in one-mode networks.

For two-mode networks, we calculate the proportion of three-paths in the network
that are closed by fourth tie to establish a "shared four-cycle" structure.

For three-mode networks, we calculate the proportion of three-paths spanning the two two-mode networks
that are closed by a fourth tie to establish a "congruent four-cycle" structure.
}
\examples{
graph_clustering(southern_women)
}
\references{
Robins, Garry L, and Malcolm Alexander. 2004.
Small worlds among interlocking directors: Network structure and distance in bipartite graphs.
\emph{Computational & Mathematical Organization Theory} 10 (1): 69–94.

Knoke, David, Mario Diani, James Hollway, and Dimitris C Christopoulos. 2021.
\href{https://www.cambridge.org/core/books/multimodal-political-networks/43EE8C192A1B0DCD65B4D9B9A7842128}{\emph{Multimodal Political Networks}}.
Cambridge University Press. Cambridge University Press.
}
\seealso{
Other one-mode measures: 
\code{\link{node_constraint}()}

Other two-mode measures: 
\code{\link{centrality}},
\code{\link{centralization}},
\code{\link{node_constraint}()},
\code{\link{node_smallworld}()}
}
\concept{one-mode measures}
\concept{three-mode measures}
\concept{two-mode measures}
