% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sum_expand.R
\name{sum_expand}
\alias{sum_expand}
\title{Sum bilateral data to include aggregate bilateral totals for origin and destination meta areas}
\usage{
sum_expand(
  m,
  return_matrix = FALSE,
  guess_order = TRUE,
  area_first = TRUE,
  orig_col = "orig",
  dest_col = "dest",
  flow_col = "flow",
  orig_area_col = "orig_area",
  dest_area_col = "dest_area",
  orig_area = NULL,
  dest_area = NULL
)
}
\arguments{
\item{m}{A \code{matrix} or data frame of origin-destination flows. For \code{matrix} the first and second dimensions correspond to origin and destination respectively. For a data frame ensure the correct column names are passed to \code{orig_col}, \code{dest_col} and \code{flow_col}.}

\item{return_matrix}{Logical to return a matrix. Default \code{FALSE}.}

\item{guess_order}{Logical to return a matrix or data frame ordered by origin and destination with area names at the end of each block. Default \code{TRUE}. If \code{FALSE} returns matrix or data frame based on alphabetical order of origin and destinations.}

\item{area_first}{Order area sums to be placed before the origin and destination values. Default \code{TRUE}}

\item{orig_col}{Character string of the origin column name (when \code{m} is a data frame rather than a \code{matrix})}

\item{dest_col}{Character string of the destination column name (when \code{m} is a data frame rather than a \code{matrix})}

\item{flow_col}{Character string of the flow column name (when \code{m} is a data frame rather than a \code{matrix})}

\item{orig_area_col}{Character string of the origin area column name (when \code{m} is a data frame rather than a \code{matrix})}

\item{dest_area_col}{Character string of the destination area column name (when \code{m} is a data frame rather than a \code{matrix})}

\item{orig_area}{Vector of labels for the origin areas of each row of \code{m}.}

\item{dest_area}{Vector of labels for the destination areas of each row of \code{m}.}
}
\value{
A \code{tibble} or \code{matrix} with additional row and columns (for matrices) for aggregate sums for origin and destination meta-regions
}
\description{
Expand matrix of data frame of migration data to include aggregate sums for corresponding origin and destination meta regions.
}
\examples{
##
## from matrix
##
m <- block_matrix(x = 1:16, b = c(2,3,4,2))
m

# requires a vector of origin and destination areas
a <- rep(LETTERS[1:4], times = c(2,3,4,2))
a
sum_expand(m = m, orig_area = a, dest_area = a)

# place area sums after regions
sum_expand(m = m, orig_area = a, dest_area = a, area_first = FALSE)

##
## from large data frame
##
\dontrun{
library(tidyverse)
library(countrycode)

# download Abel and Cohen (2019) estimates
f <- read_csv("https://ndownloader.figshare.com/files/38016762", show_col_types = FALSE)
f

# 1990-1995 flow estimates
f \%>\%
  filter(year0 == 1990) \%>\%
  mutate(
    orig_area = countrycode(sourcevar = orig, custom_dict = dict_ims,
                            origin = "iso3c", destination = "region"),
    dest_area = countrycode(sourcevar = dest, custom_dict = dict_ims,
                            origin = "iso3c", destination = "region")
  ) \%>\%
  sum_expand(flow_col = "da_pb_closed", return_matrix = FALSE)

# by group (period)
f \%>\%
  mutate(
    orig_area = countrycode(sourcevar = orig, custom_dict = dict_ims,
                            origin = "iso3c", destination = "region"),
    dest_area = countrycode(sourcevar = dest, custom_dict = dict_ims,
                            origin = "iso3c", destination = "region")
  ) \%>\%
  group_by(year0) \%>\%
  sum_expand(flow_col = "da_pb_closed", return_matrix = FALSE)
}
}
