% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/net_vs.R
\name{net_vs}
\alias{net_vs}
\title{Estimate net migration from vital statistics}
\usage{
net_vs(
  .data,
  pop0_col = NULL,
  pop1_col = NULL,
  births_col = "births",
  deaths_col = "deaths"
)
}
\arguments{
\item{.data}{A data frame with two rows with the total number of lifetime in- and out-migrants in separate columns. The first row contains totals at the first time point and second row at the second time point.}

\item{pop0_col}{Character string name of column containing name of initial populations. Default \code{"pop0"}.}

\item{pop1_col}{Character string name of column containing name of end populations. Default \code{"pop1"}.}

\item{births_col}{Character string name of column containing name of births over the period. Default \code{"births"}.}

\item{deaths_col}{Character string name of column containing name of deaths over the period. Default \code{"deaths"}.}
}
\value{
A tibble with additional columns for the population change (`pop_change`), the natural population incearse (`natural_inc`) and the net migration (`net`) over the period.
}
\description{
Estimate net migration from vital statistics
}
\examples{
library(dplyr)
d <- alabama_1970 \%>\%
  group_by(race, sex) \%>\%
  summarise(births = sum(pop_1960[1:2]),
            pop_1960 = sum(pop_1960) - births,
            pop_1970 = sum(pop_1970)) \%>\%
  ungroup()
d

d \%>\%
  mutate(deaths = c(51449, 58845, 86880, 123220)) \%>\%
  net_vs(pop0_col = "pop_1960", pop1_col = "pop_1970")
}
