% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_mid.R
\name{summary.mid}
\alias{summary.mid}
\title{Summarize MID Models}
\usage{
\method{summary}{mid}(object, digits = max(3L, getOption("digits") - 2L), top.n = 10L, ...)
}
\arguments{
\item{object}{a "mid" object to be summarized.}

\item{digits}{an integer specifying the number of significant digits.}

\item{top.n}{an integer specifying the maximum number of terms to be printed with the MID importance values.}

\item{...}{not used.}
}
\value{
\code{summary.mid()} returns the "mid" object passed to the function without any modification.
}
\description{
For "mid" objects, \code{summary()} prints information about the fitted MID model.
}
\details{
The S3 method of \code{summary()} for "mid" objects prints basic information about the MID model including the uninterpreted variation ratio, residuals, encoding schemes, and MID importance.
}
\examples{
data(cars, package = "datasets")
summary(interpret(dist ~ speed, cars))
}
