% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{fye_proxy}
\alias{fye_proxy}
\title{Starting program proxies for FYE students}
\format{
\code{data.table} with 4623 rows and 2 columns keyed by student ID. The
variables are:

\describe{

\item{\code{mcid}}{Character, de-identified student ID.}

\item{\code{proxy}}{Character, 6-digit CIP code of the estimated proxy
program.}

}
}
\usage{
fye_proxy
}
\description{
Proxies are the degree-granting engineering programs we estimate that
First-Year Engineering (FYE) students would have declared had they not been
required to enroll in FYE. Keyed by student ID. Proxies are provided for all
students in the midfielddata practice data who enroll in FYE in their first
term.
}
\details{
The proxy variable contains 6-digit CIP codes of degree-granting engineering
programs, e.g., Electrical Engineering, Mechanical Engineering, etc., that
are substituted for the FYE CIP code when an analysis requires
degree-granting starting programs. The most common application is a
graduation rate calculation.

The estimation is based on students' first post-FYE programs and a multiple
imputation suitable for categorical variables using the mice package. The
predictor variables are institution, race, and sex. The estimated variable is
the 6-digit CIP code of a degree-granting engineering program at their
institution.

\code{fye_proxy} holds only for the practice data in midfielddata---these values
cannot be commingled with the MIDFIELD research database.
}
\seealso{
Other cip-data: 
\code{\link{cip}}
}
\concept{cip-data}
\keyword{datasets}
