% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/midas_functions.R
\name{midas_forecast}
\alias{midas_forecast}
\title{MIDAS regression prediction function}
\usage{
midas_forecast(params, x, ylag, polynomial, ...)
}
\arguments{
\item{params}{parameter vector from \code{midas_estimate}.}

\item{x}{out-of-sample predictor variable data.}

\item{ylag}{out-of-sample lagged dependent variable data.}

\item{polynomial}{polynomial specification.}

\item{...}{optional parameters to feed into other functions. 
\code{step_idx} - index for step function polynomial specification (warning: if left unspecified, the program computes index the same way as in the estimation function), 
\code{legendre_degree} - the degree of Legendre polynomials (warning: if left unspecified, the program sets it to 3, the same way as in the estimation function).}
}
\value{
returns prediction value.
}
\description{
Predicts from single variate MIDAS model estimated based on specification supplied to \code{midas_estimate} function.
}
\details{
For specficiation details, see \code{midas_dl} or \code{midas_ardl} function descriptions for more details.
}
\author{
Jonas Striaukas
}
\keyword{internal}
