% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/schemeStatistics.R
\name{pkCurveStat}
\alias{pkCurveStat}
\alias{pkCurveStat_auc}
\alias{auc}
\alias{pkCurveStat_cMax}
\alias{cMax}
\alias{pkCurveStat_tMax}
\alias{tMax}
\title{calculate summary statistics from a pkCurve}
\usage{
pkCurveStat_auc(concentration, timePoints)

pkCurveStat_cMax(concentration, timePoints)

pkCurveStat_tMax(concentration, timePoints)
}
\arguments{
\item{concentration}{numeric vector of concentrations corresponding to \code{timePoints}}

\item{timePoints}{\code{time} and \code{concentration}}
}
\value{
a numeric value
}
\description{
implemented statistics:
\itemize{
  \item{auc }{ area under the curve , between first and last time points }
  \item{cMax }{ maximum concentration}
  \item{tMax }{ time at maximum concentration }
}
}
\examples{
  ## toy example
  timeToy               <-  1:2
  concToy               <-  1:2 
 
  pkCurveStat_auc( concToy ,  timeToy ) 
  pkCurveStat_cMax( concToy ,  timeToy  )
  pkCurveStat_tMax( concToy ,  timeToy  )

  ## real example
  times                 <-  c(0 , 1.5 , 2:10)
  concentration         <-  getExamplePkCurve( times )
  pkCurveStat_auc( concentration , times  ) 
  pkCurveStat_cMax( concentration , times   )
  pkCurveStat_tMax( concentration , times   )

}
