% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetch_datasus.R
\name{fetch_datasus}
\alias{fetch_datasus}
\title{Fetch and read microdata files from DataSUS}
\usage{
fetch_datasus(
  year_start,
  month_start = NULL,
  year_end,
  month_end = NULL,
  uf = "all",
  information_system,
  vars = NULL,
  stop_on_error = FALSE,
  timeout = 240,
  track_source = FALSE
)
}
\arguments{
\item{year_start, year_end}{numeric. Start and end year of files in the format yyyy.}

\item{month_start, month_end}{numeric. Start and end month in the format mm. Those parameters are only used with the healh information systems SIH, CNES and SIA. There parameter are ignored if the information health system is SIM or SINASC.}

\item{uf}{an optional string or a vector of strings. By default all UFs ("Unidades Federativas") are download. See \emph{Details}.}

\item{information_system}{string. The abbreviation of the health information system to be accessed. See \emph{Details}.}

\item{vars}{an optional string or a vector of strings. By default, all variables read and stored, unless a list of desired variables is informed by this parameter.}

\item{stop_on_error}{logical. If TRUE, the download process will be stopped if an error occurs.}

\item{timeout}{numeric (seconds). Sets a timeout tolerance for downloads, usefull on large files and/or slow connections. Defaults to 240 seconds.}

\item{track_source}{logical. If \code{TRUE}, adds a column called \code{source} with the downloaded file name.}
}
\value{
a \code{data.frame} with the contents of the DBC files.
}
\description{
\code{fetch_datasus} downloads microdata (DBC) files from DataSUS and reads them.
}
\details{
This function downloads DBC files from DataSUS following parameters about start date, end date, UF and health information system abbreviation. After the download process, the files are merged into a unique \code{data.frame} object.

A specific UF or a vector of UFs can be informed using the following abbreviations: "AC", "AL", "AP", "AM", "BA", "CE", "DF", "ES", "GO", "MA", "MT", "MS", "MG", "PA", "PB", "PR", "PE", "PI", "RJ", "RN", "RS", "RO", "RR", "SC", "SP", "SE", "TO".

The following systems are implemented: "SIH-RD", "SIH-RJ", "SIH-SP", "SIH-ER", "SIM-DO", "SIM-DOFET", "SIM-DOEXT", "SIM-DOINF", "SIM-DOMAT", "SINASC", "CNES-LT", "CNES-ST", "CNES-DC", "CNES-EQ", "CNES-SR", "CNES-HB", "CNES-PF", "CNES-EP", "CNES-RC", "CNES-IN", "CNES-EE", "CNES-EF", "CNES-GM", "SIA-AB", "SIA-ABO", "SIA-ACF", "SIA-AD", "SIA-AN", "SIA-AM", "SIA-AQ", "SIA-AR", "SIA-ATD", "SIA-PA", "SIA-PS", "SIA-SAD", "SINAN-DENGUE-FINAL", "SINAN-DENGUE-PRELIMINAR", "SINAN-CHIKUNGUNYA-FINAL", "SINAN-CHIKUNGUNYA-PRELIMINAR", "SINAN-ZIKA-FINAL", "SINAN-ZIKA-PRELIMINAR", "SINAN-MALARIA-FINAL", "SINAN-MALARIA-PRELIMINAR".
}
\section{Warning}{

A Internet connection is needed to use this function.

Currently, DataSUS FTP server is restricting download calls from some countries, except Brazil.

The year and month used to download the files regards the processing month and year of the cases by DataSUS.

The UF regards where the cases were processed by DataSUS.

The files are downloaded to a temporary folder and deleted after the reading process.
}

\examples{
\dontshow{if (curl::has_internet() & RCurl::url.exists("ftp.datasus.gov.br", timeout.ms = 100)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Fetch two years of data from SIM-DO
fetch_datasus(year_start = 2010, year_end = 2011,
              information_system = "SIM-DO")

# Fetch one year of data from SIM-DO and keep only three variables
fetch_datasus(year_start = 2014, year_end = 2014,
              information_system = "SIM-DO",
              vars = c("CODMUNRES", "DTOBITO", "CAUSABAS"))

# Fetch some months' data from SIH-RD for four states
fetch_datasus(year_start = 2014, month_start = 1,
              year_end = 2014, month_end = 2,
              uf = c("RJ", "MG", "SP", "ES"),
              information_system = "SIH-RD")
\dontshow{\}) # examplesIf}
}
