% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{medoids}
\alias{medoids}
\title{The ConTax medoids}
\usage{
data(medoids)
}
\description{
The genus medoids from the ConTax data set.
}
\details{
\code{medoids} is a \code{\link[microseq]{Fasta}} object containing the medoide sequences for each genus in 
the ConTax data sets (both \code{contax.trim} and \code{contax.full}).

The medoide sequence in a genus is the sequence having the smallest sum of distance to all other members
of the same genus. Thus, it is the sequence closest to the centre of the genus. The medoids can be used as
the representative of each genus, e.g. for building trees for the entire taxonomy.

The taxonomy information for each sequence can be extracted from the \code{Header} column by the supplied
extractor-functions \code{\link{getDomain}}, \code{\link{getPhylum}},...,\code{\link{getGenus}}.
}
\examples{
data(medoids)
summary(medoids)

}
\author{
Hilde Vinje, Kristian Hovde Liland, Lars Snipen.
}
\seealso{
\code{\link[microcontax.data]{contax.full}}, \code{\link{getDomain}}.
}

