% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/error_rates.R
\name{fdr_fun}
\alias{fdr_fun}
\title{Calculates FDR when ground truth is available}
\usage{
fdr_fun(z, id)
}
\arguments{
\item{z}{Vector of cluster assignments}

\item{id}{Vector of true cluster assignments (ground truth)}
}
\value{
FDR
}
\description{
Calculates FDR when ground truth is available
}
\examples{
truePartition <- c(50,50,50,50)
maxPartitionSize<- length(truePartition)
uniqueNumberRecords <- sum(truePartition)
id <- rep(1:uniqueNumberRecords, times=rep(1:maxPartitionSize, times=truePartition))
fdr_fun(z = truePartition, id)
}
