% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pool_cindex.R
\name{pool_cindex}
\alias{pool_cindex}
\title{Calculates the pooled C-index and Confidence intervals}
\usage{
pool_cindex(data, conf.level = 0.95, dfcom = NULL)
}
\arguments{
\item{data}{An object of class 'mistats' ('Multiply Imputed
Statistical Analysis'.) or a m x 2 matrix with C-index
values and standard errors in the columns. For the latter option
dfcom has to be provided.}

\item{conf.level}{conf.level Confidence level of the confidence intervals.}

\item{dfcom}{Number of completed-data analysis degrees of freedom.
Default number is taken from function \code{cindex}}
}
\value{
The pooled c-index value and the confidence intervals.
}
\description{
\code{pool_cindex} Calculates the pooled C-index and Confidence intervals.
}
\details{
Rubin's Rules are used for pooling. The C-index values are log
transformed before pooling and finally back transformed.
}
\section{Vignettes}{

https://mwheymans.github.io/miceafter/articles/pooling_cindex.html
}

\examples{

 # Logistic Regression
 imp_dat <- df2milist(lbpmilr, impvar="Impnr")
 res_stats <- with(data=imp_dat,
  expr = cindex(glm(Chronic ~ Gender + Radiation,
  family=binomial)))
 res <- pool_cindex(res_stats)
 res

 # Cox regression
 library(survival)
 imp_dat <- df2milist(lbpmicox, impvar="Impnr")
 res_stats <- with(data=imp_dat,
   expr = cindex(coxph(Surv(Time, Status) ~ Pain + Radiation)))
 res <- pool_cindex(res_stats)
 res

}
\seealso{
\code{\link{with.milist}}, \code{\link{cindex}}
}
\author{
Martijn Heymans, 2021
}
