%% File Name: nnig_sim.Rd
%% File Version: 0.244

\name{nnig_sim}
\alias{nnig_coef}
\alias{nnig_sim}
%- Also NEED an '\alias' for EACH other topic documented here.

\title{
Simulation of Multivariate Linearly Related Non-Normal Variables
}


\description{
Simulates multivariate linearly related non-normally distributed variables
(Foldnes & Olsson, 2016). For marginal distributions, skewness and (excess) kurtosis
values are provided and the values are simulated according to the Fleishman
power transformation (Fleishman, 1978; see \code{\link{fleishman_sim}}).

The function \code{nnig_sim} simulates data from a multivariate random variable
\eqn{\bold{Y}} which is related to a number of independent variables \eqn{\bold{X}}
(independent generators; Foldnes & Olsson, 2016)
which are Fleishman power normally distributed. In detail, it holds that
\eqn{\bold{Y}=\bold{\mu} + \bold{A} \bold{X}} where the covariance matrix
\eqn{\bold{\Sigma}} is decomposed according to a Cholesky decomposition
\eqn{\bold{\Sigma}=\bold{A} \bold{A}^T}.
}


\usage{
# determine coefficients
nnig_coef(mean=NULL, Sigma, skew, kurt)

# simulate values
nnig_sim(N, coef)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{mean}{
Vector of means. The default is a vector containing zero means.
}
  \item{Sigma}{
Covariance matrix
}
  \item{skew}{
Vector of skewness values
}
  \item{kurt}{
Vector of (excess) kurtosis values
}
\item{N}{Number of cases}
\item{coef}{List of parameters generated by \code{nnig_coef}}
}


%\details{
%%  ~~ If necessary, more details than the description above ~~
%}


\value{
A list of parameter values (\code{nnig_coef}) or a data frame with
simulated values (\code{nnig_sim}).
}

\references{
Fleishman, A. I. (1978). A method for simulating non-normal distributions.
\emph{Psychometrika, 43}(4), 521-532.
\doi{10.1007/BF02293811}

Foldnes, N., & Olsson, U. H. (2016). A simple simulation technique for nonnormal data
with prespecified skewness, kurtosis, and covariance matrix.
\emph{Multivariate Behavioral Research, 51}(2-3), 207-219.
\doi{10.1080/00273171.2015.1133274}

Vale, D. C., & Maurelli, V. A. (1983). Simulating multivariate nonnormal distributions.
\emph{Psychometrika, 48}(3), 465-471.
\doi{10.1007/BF02293687}
}

%\author{
%%  ~~who you are~~
%}
%\note{
%%  ~~further notes~~
%}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
See \code{fungible::monte1} for simulating multivariate linearly related
non-normally distributed variables generated by the method of Vale and Morelli (1983).
See also the \code{MultiVarMI::MVNcorr} function in the \bold{MultiVarMI} package
and the \bold{SimMultiCorrData} package.

The \bold{MultiVarMI} also includes an imputation function \code{MultiVarMI::MI}
for non-normally distributed variables.
}


\examples{
\dontrun{
#############################################################################
# EXAMPLE 1: Simulating data with nnig_sim function
#############################################################################

#* define input parameters
Sigma <- matrix( c(1,.5, .2,
                  .5, 1,.7,
                  .2, .7, 1), 3, 3 )
skew <- c(0,1,1)
kurt <- c(1,3,3)

#* determine coefficients
coeff <- miceadds::nnig_coef( Sigma=Sigma, skew=skew, kurt=kurt )
print(coeff)

#* simulate data
set.seed(2018)
Y <- miceadds::nnig_sim( N=2000, coef=coeff)

#* check descriptive statistics
apply(Y, 2, TAM::weighted_skewness )
apply(Y, 2, TAM::weighted_kurtosis )
}
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
%\keyword{ ~kwd1 }% use one of  RShowDoc("KEYWORDS")
%\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
