% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mice.impute.2lonly.pmm.R
\name{mice.impute.2lonly.pmm}
\alias{mice.impute.2lonly.pmm}
\alias{2lonly.pmm}
\title{Imputation at level 2 by predictive mean matching}
\usage{
mice.impute.2lonly.pmm(y, ry, x, type, wy = NULL, ...)
}
\arguments{
\item{y}{Vector to be imputed}

\item{ry}{Logical vector of length \code{length(y)} indicating the 
the subset \code{y[ry]} of elements in \code{y} to which the imputation 
model is fitted. The \code{ry} generally distinguishes the observed 
(\code{TRUE}) and missing values (\code{FALSE}) in \code{y}.}

\item{x}{Numeric design matrix with \code{length(y)} rows with predictors for 
\code{y}. Matrix \code{x} may have no missing values.}

\item{type}{Group identifier must be specified by '-2'. Predictors must be
specified by '1'.}

\item{wy}{Logical vector of length \code{length(y)}. A \code{TRUE} value 
indicates locations in \code{y} for which imputations are created.}

\item{...}{Other named arguments.}
}
\value{
A vector of length \code{nmis} with imputations.
}
\description{
Imputes univariate missing data at level 2 using predictive mean matching.
Variables are level 1 are aggregated at level 2. The group identifier at
level 2 must be indicated by \code{type=-2} in the \code{predictorMatrix}.
}
\details{
This function allows in combination with \code{\link{mice.impute.2l.pan}}
switching regression imputation between level 1 and level 2 as described in
Yucel (2008) or Gelman and Hill (2007, p. 541).
}
\note{
The extension to categorical variables transform 
a dependent factor variable by means of the \code{as.integer()}
function. This may make sense for categories that are 
approximately ordered, and less so for pure nominal measures.
}
\examples{

##################################################
# simulate some data
# x,y ... level 1 variables
# v,w ... level 2 variables

G <- 250            # number of groups
n <- 20             # number of persons
beta <- .3          # regression coefficient
rho <- .30          # residual intraclass correlation
rho.miss <- .10     # correlation with missing response
missrate <- .50     # missing proportion
y1 <- rep( rnorm( G , sd = sqrt( rho ) ) , each=n ) + rnorm(G*n , sd = sqrt( 1 - rho )) 
w <- rep( round( rnorm(G ) , 2 ) , each=n )
v <- rep( round( runif( G , 0 , 3 ) ) , each=n )
x <-  rnorm( G*n ) 
y <- y1 + beta  * x + .2 * w + .1 * v
dfr0 <- dfr <- data.frame( "group" = rep(1:G , each=n ) , "x" = x , "y" = y , "w" = w , "v" = v )
dfr[ rho.miss * x + rnorm( G*n , sd = sqrt( 1 - rho.miss ) ) < qnorm( missrate ) , "y" ] <- NA
dfr[ rep( rnorm(G) , each=n ) < qnorm( missrate ) , "w" ] <- NA
dfr[ rep( rnorm(G) , each=n ) < qnorm( missrate ) , "v" ] <- NA

#....
# empty mice imputation
imp0 <- mice( as.matrix(dfr)  , maxit=0 )
predM <- imp0$predictorMatrix
impM <- imp0$method

#...
# multilevel imputation
predM1 <- predM
predM1[c("w","y","v"),"group"] <- -2
predM1["y","x"] <- 1        # fixed x effects imputation
impM1 <- impM
impM1[c("y","w","v")] <- c("2l.pan" , "2lonly.norm" , "2lonly.pmm" )

# turn v into a categorical variable
dfr$v <- as.factor(dfr$v)
levels(dfr$v) <- LETTERS[1:4]

# y ... imputation using pan
# w ... imputation at level 2 using norm
# v ... imputation at level 2 using pmm

imp <- mice(dfr, m = 1, predictorMatrix = predM1 , 
           imputationMethod = impM1, maxit = 1, paniter = 500)

}
\references{
Gelman, A. and Hill, J. (2007). \emph{Data analysis using
regression and multilevel/hierarchical models}. Cambridge, Cambridge
University Press.

Yucel, RM (2008). Multiple imputation inference for multivariate multilevel
continuous data with ignorable non-response.  \emph{Philosophical
Transactions of the Royal Society A}, \bold{366}, 2389-2404.
}
\seealso{
\code{\link{mice.impute.pmm}},
\code{\link{mice.impute.2lonly.norm}}, \code{\link{mice.impute.2l.pan}}

Other univariate \code{2lonly} functions: \code{\link{mice.impute.2lonly.mean}},
  \code{\link{mice.impute.2lonly.norm}}
}
\author{
Alexander Robitzsch (IPN - Leibniz Institute for Science and 
Mathematics Education, Kiel, Germany), \email{robitzsch@ipn.uni-kiel.de}.
}
