% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mice.impute.ri.r
\name{mice.impute.ri}
\alias{mice.impute.ri}
\alias{ri}
\title{Imputation by the random indicator method for nonignorable data}
\usage{
mice.impute.ri(y, ry, x, wy = NULL, ri.maxit = 10, ...)
}
\arguments{
\item{y}{Vector to be imputed}

\item{ry}{Logical vector of length \code{length(y)} indicating the 
the subset \code{y[ry]} of elements in \code{y} to which the imputation 
model is fitted. The \code{ry} generally distinguishes the observed 
(\code{TRUE}) and missing values (\code{FALSE}) in \code{y}.}

\item{x}{Numeric design matrix with \code{length(y)} rows with predictors for 
\code{y}. Matrix \code{x} may have no missing values.}

\item{wy}{Logical vector of length \code{length(y)}. A \code{TRUE} value 
indicates locations in \code{y} for which imputations are created.}

\item{ri.maxit}{Number of inner iterations}

\item{...}{Other named arguments.}
}
\value{
Vector with imputed data, same type as \code{y}, and of length 
\code{sum(wy)}
}
\description{
Imputes nonignorable missing data by the random indicator method.
}
\details{
The random indicator method estimates an offset between the 
distribution of the observed and missing data using an algorithm 
that iterates over the response and imputation models. 

This routine assumes that the response model and imputation model
}
\references{
Jolani, S. (2012). 
\emph{Dual Imputation Strategies for Analyzing Incomplete Data}. 
Disseration. University of Utrecht, Dec 7 2012.
}
\seealso{
Other univariate imputation functions: \code{\link{mice.impute.cart}},
  \code{\link{mice.impute.lda}},
  \code{\link{mice.impute.logreg.boot}},
  \code{\link{mice.impute.logreg}},
  \code{\link{mice.impute.mean}},
  \code{\link{mice.impute.midastouch}},
  \code{\link{mice.impute.norm.boot}},
  \code{\link{mice.impute.norm.nob}},
  \code{\link{mice.impute.norm.predict}},
  \code{\link{mice.impute.norm}},
  \code{\link{mice.impute.pmm}},
  \code{\link{mice.impute.polr}},
  \code{\link{mice.impute.polyreg}},
  \code{\link{mice.impute.quadratic}},
  \code{\link{mice.impute.rf}}
}
\author{
Shahab Jolani (University of Utrecht) \email{s.jolani@uu.nl}
}
\keyword{datagen}
