% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mica.studies.R
\name{mica.studies}
\alias{mica.studies}
\title{Get the studies}
\usage{
mica.studies(
  mica,
  query = "study()",
  select = list("acronym", "name", "objectives", "model",
    "populations.dataCollectionEvents.model.dataSources"),
  sort = list("id"),
  from = 0,
  limit = 100,
  locale = "en",
  df = TRUE
)
}
\arguments{
\item{mica}{A Mica object}

\item{query}{The search query}

\item{select}{The fields to be extracted}

\item{sort}{The fields to sort by}

\item{from}{From item}

\item{limit}{Max number of items}

\item{locale}{The language for labels (default is "en")}

\item{df}{Return a data.frame (default is TRUE)}
}
\description{
Get the studies
}
\examples{
\dontrun{
m <- mica.login("https://mica-demo.obiba.org")
mica.studies(m, query="variable(in(Mlstr_area.Lifestyle_behaviours,Drugs))", 
  locale="en", from=0, limit=10)
mica.logout(m)
}
}
\seealso{
Other studies functions: 
\code{\link{mica.study.dces}()},
\code{\link{mica.study.populations}()}
}
\concept{studies functions}
