% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/mhde.R
\name{mhde.crit}
\alias{mhde.crit}
\title{Utility function for retrieving the critical value for any sample size and desired \eqn{\alpha} level}
\usage{
mhde.crit(Nsize, Plevel = 0.95)
}
\arguments{
\item{Nsize}{The sample size is defined using \code{Nsize}.  No default value is set.}

\item{Plevel}{The probability level associated with the critical value is set using \code{Plevel}.  The default value is 0.95.  The \eqn{\alpha} level of the test is 1-\code{Plevel}.}
}
\value{
pval   Critical value for the minimized Hellinger distance
}
\description{
This function calculates the critical value for the minimized Hellinger distance for a given sample size
  and probability level for a goodness of fit test for normality.

  P values below 0.0001 return the value for p=0.0001
  P values above 0.9999 return the value for p=0.9999

  This utility function is not used by the other functions.  It is provided as a "curiosity" for users.
}
\examples{
## example using default alpha level of .05
mhde.crit(45)

## example using alpha level of .01
mhde.crit(45, 0.99)
}

