% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KM2_plots.R
\name{plotKM2.HM}
\alias{plotKM2.HM}
\title{Uses a heat map to visualize a bivariate survival function}
\usage{
plotKM2.HM(
  km2.obj,
  contour = TRUE,
  col = terrain.colors(100),
  xlab = "T1",
  ylab = "T2",
  ...
)
}
\arguments{
\item{km2.obj}{Output of the KM2 function.}

\item{contour}{Should contour lines be added to the plot? Defaults to
TRUE.}

\item{col}{List of colors for the heat map. Defaults to
terrain.colors(100).}

\item{xlab}{The x-axis label. Defaults to "T1".}

\item{ylab}{The y-axis label. Defaults to "T2".}

\item{...}{Additional parameters to the image function.}
}
\description{
Plots a heat map of an estimated bivariate survival function. This
function is a wrapper for the image function with default parameters
chosen to make the data easier to visualize.
}
\examples{
x <- genClayton2(1000, 0, 1, 1, 2, 2)
x.km2 <- KM2(x$Y1, x$Y2, x$Delta1, x$Delta2)
plotKM2.HM(x.km2)

x2 <- genClayton2(1000, 2, 1, 1, 2, 2)
x2.km2 <- KM2(x2$Y1, x2$Y2, x2$Delta1, x2$Delta2)
plotKM2.HM(x2.km2)
}
\seealso{
\code{\link{KM2}}, \code{\link[graphics]{image}}
}
