% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mgee2v.R
\name{mgee2v}
\alias{mgee2v}
\title{mgee2v}
\usage{
mgee2v(
  obsform,
  id,
  obsdat,
  OR.str = "exchangeable",
  W.nam = "W",
  delta.nam = "delta",
  Y.mcform,
  X.mcform,
  maxit = 50,
  tol = 0.001
)
}
\arguments{
\item{obsform}{a formula object which specifies the relationship between 
the response and covariates for the observed data.}

\item{id}{a character object which records individual id in the data.}

\item{obsdat}{a dataframe or matrix object for the observed data set.}

\item{OR.str}{a character object. The default value is "exchangeable", 
corresponding to the structure where the association between two paired 
responses is considered to be a constant. The other option is "log-linear" 
which  indicates the log-linear association between two paired responses.}

\item{W.nam}{a character object which names the error-prone covariate W.}

\item{delta.nam}{a string object which names the indicator variable delta. 
When a data point belongs to the validation set, delta = 1; otherwise 0.}

\item{Y.mcform}{a string object which indicates the misclassification formula
between true response Y and surrogate(observed) response S.}

\item{X.mcform}{a string object which indicates the  misclassification formula
between true error-prone covariate X and surrogate W.}

\item{maxit}{an integer which specifies the maximum number of iterations. The default is 50.}

\item{tol}{a numeric object which indicates the tolerance threshold. The default is 1e-3.}
}
\value{
A list with component
    \item{beta}{Coefficients in the order of 1) all non-baseline levels for response,
    2) covariates - same order as specified in the formula}
    \item{alpha}{Coefficients for paired responses global odds ratios. Number of alpha
    coefficients corresponds to the paired responses odds ratio structure selected in "OR.str";
    when OR.str="exchangeable", only one baseline alpha is fitted.}
    \item{variance}{variance-covariance matrix of all fitted parameters}
    \item{convergence}{a logical variable, TRUE if the model converges}
    \item{iteration}{number of iterations for the model to converge}
    \item{call}{Function called}
}
\description{
Corrected GEE2 for ordinal data, with validation subsample
}
\examples{
  if(0){
  data(obs1)
  obs1$Y <- as.factor(obs1$Y)
  obs1$X <- as.factor(obs1$X)
  obs1$visit <- as.factor(obs1$visit)
  obs1$treatment <- as.factor(obs1$treatment)
  obs1$S <- as.factor(obs1$S)
  obs1$W <- as.factor(obs1$W)
  mgee2v.fit = mgee2v(obsform = S~W+treatment+visit, id = "ID", obsdat = obs1,
                      Y.mcform = "S~1", X.mcform = "W~1", W.nam = "W",delta.nam = "delta",
                      OR.str = "exchangeable")
  }
}
