% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acd.R
\name{fit_acd}
\alias{fit_acd}
\title{Function to estimate approximate cumulative distribution (ACD)}
\usage{
fit_acd(x, powers = NULL, shift = 0, scale = 1)
}
\arguments{
\item{x}{a numeric vector.}

\item{powers}{a vector of allowed FP powers. The default value is \code{NULL},
meaning that the set \eqn{S = (-2, -1, -0.5, 0, 0.5, 1, 2, 3)} is used.}

\item{shift}{a numeric that is used to shift the values of \code{x} to positive
values. The default value is 0, meaning no shifting is conducted.
If \code{NULL}, then the program will estimate an appropriate shift automatically
(see \code{\link[=find_shift_factor]{find_shift_factor()}}).}

\item{scale}{a numeric used to scale \code{x}. The default value is 1, meaning
no scaling is conducted. If \code{NULL}, then the program will estimate
an appropriate scaling factor automatically (see \code{\link[=find_scale_factor]{find_scale_factor()}}).}
}
\value{
A list is returned with components
\itemize{
\item \code{acd}: the acd transformed input data.
\item \code{beta0}: intercept of estimated model.
\item \code{beta1}: coefficient of estimated model.
\item \code{power}: estimated power.
\item \code{shift}: shift value used for computations.
\item \code{scale}: scaling factor used for computations.
}
}
\description{
Fits ACD transformation as outlined in Royston (2014). The ACD transformation
smoothly maps the observed distribution of a continuous covariate x onto one scale,
namely, that of an approximate uniform distribution on the interval (0, 1).
}
\details{
Briefly, the estimation works as follows. First, the input data are shifted
to positive values and scaled as requested. Then
\deqn{z = \Phi^{-1}(\frac{rank(x) - 0.5}{n}) }
is computed, where \eqn{n} is the number of elements in \code{x},
with ties in the ranks handled as averages. To approximate \eqn{z},
an FP1 model (least squares) is used, i.e.
\eqn{E(z) = \beta_0 + \beta_1 (x)^p}, where \eqn{p} is chosen such that it
provides the best fitting model among all possible FP1 models.
The ACD transformation is then given as
\deqn{acd(x) = \Phi(\hat{z}),}
where the fitted values of the estimated model are used.
If the relationship between a response Y and acd(x) is linear,
say, \eqn{E(Y) = \beta_0 + \beta_1 acd(x)}, the relationship between Y
and x is nonlinear and is typically sigmoid in shape.
The parameters \eqn{\beta_0} and \eqn{\beta_0 + \beta_1} in such a model are
interpreted as the expected values of Y at the minimum and maximum of x,
that is, at acd(x) = 0 and 1, respectively.
The parameter \eqn{\beta_1} represents the range of predictions of \eqn{E(Y)}
across the whole observed distribution of x (Royston 2014).
}
\examples{

set.seed(42)
x = apply_shift_scale(rnorm(100))
y = rnorm(100)
fit_acd(x, y)

}
\references{
Royston, P. and Sauerbrei, W. (2016). \emph{mfpa: Extension of mfp using the
ACD covariate transformation for enhanced parametric multivariable modeling.
The Stata Journal, 16(1), pp.72-87.}

Royston, P. (2014). \emph{A smooth covariate rank transformation for use in
regression models with a sigmoid dose–response function. The Stata Journal,
14(2), 329-341}.
}
